/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import com.tailrocks.graphql.datetime.CoercingUtil;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

@Internal
public class GraphqlOffsetDateTimeCoercing
implements Coercing<OffsetDateTime, String> {
    private OffsetDateTime convertImpl(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            try {
                return OffsetDateTime.parse(string, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        } else if (input instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)input;
            return offsetDateTime;
        }
        return null;
    }

    public String serialize(Object input) {
        if (input instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)input;
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(offsetDateTime);
        }
        OffsetDateTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(this.getErrorMessage(input));
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(result);
    }

    public OffsetDateTime parseValue(Object input) {
        OffsetDateTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(this.getErrorMessage(input));
        }
        return result;
    }

    public OffsetDateTime parseLiteral(Object input) {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        String value = ((StringValue)input).getValue();
        OffsetDateTime result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException(this.getErrorMessage(input));
        }
        return result;
    }

    private String getErrorMessage(Object input) {
        return "Invalid value '" + input + "' for OffsetDateTime";
    }
}

