/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.VariableInput;
import com.takipi.common.util.ArrayUtil;
import com.takipi.common.util.ObjectUtil;
import com.takipi.integrations.functions.annotations.Param;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseEnvironmentsInput
extends VariableInput {
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="A comma delimited array of environments names to use as a filter. \n Specify null, \"\", \"all\" or \"*\" to clear selection, in which case no environments are selected.\n", defaultValue="$environments")
    public String environments;
    public static int MAX_COMBINE_SERVICES = 3;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description="Control whether the information returned is limited to MAX_COMBINE_SERVICES, or allows the user to selected an unlimited number of envs to query.", defaultValue="false")
    public boolean unlimited;

    public static List<String> getServiceIds(String environments) {
        if (!BaseEnvironmentsInput.hasFilter(environments)) {
            return Collections.emptyList();
        }
        String[] serviceIds = ArrayUtil.safeSplitArray(environments, GRAFANA_SEPERATOR, false);
        if (serviceIds.length == 1 && serviceIds[0].equals("()")) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < serviceIds.length; ++i) {
            String service = serviceIds[i];
            String value = service.replace("(", "").replace(")", "");
            String[] parts = value.split(": ");
            String serviceId = parts.length > 1 ? parts[parts.length - 1] : value;
            if (service.startsWith("$")) continue;
            result.add(serviceId);
        }
        return result;
    }

    public List<String> getServiceIds() {
        return BaseEnvironmentsInput.getServiceIds(this.environments);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseEnvironmentsInput)) {
            return false;
        }
        return ObjectUtil.equal((Object)this.environments, (Object)((BaseEnvironmentsInput)((Object)obj)).environments);
    }

    public int hashCode() {
        if (this.environments == null) {
            return super.hashCode();
        }
        return this.environments.hashCode();
    }
}

