/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.BaseEnvironmentsInput;
import com.takipi.common.util.ObjectUtil;
import com.takipi.integrations.functions.annotations.Param;

public abstract class EnvironmentsFilterInput
extends BaseEnvironmentsInput {
    public static final String APP_LABEL_PREFIX = "--";
    public static final String DEFAULT_APPS = "$applications";
    public static final String DEFAULT_DEPS = "$deployments";
    public static final String DEFAULT_SERVERS = "$servers";
    @Param(type=Param.ParamType.String, advanced=false, literals={}, defaultValue="$applications", description="A comma delimited array of application names to use as a filter. Specify \"\", \"all\" or \"*\" to skip\n")
    public String applications;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, defaultValue="$servers", description="A comma delimited array of server group names to use as a filter. Specify \"\", \"all\" or \"*\" to skip\n")
    public String servers;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, defaultValue="$deployments", description="A comma delimited array of deployments names to use as a filter. Specify \"\", \"all\" or \"*\" to skip\n")
    public String deployments;
    public static final String TIME_FILTER_SELECTION = "timeFilter";
    public static final String TIME_FILTER_DEPLOYMENT_TIMESPAN = "invocations";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"timeFilter", "invocations"}, defaultValue="invocations", description="Control which timeframe is used by this function for querying data:\ntimeFilter: use the provided timeFilter when querying data\ninvocations: if deployment filters are provided use their timespan when quering data\n")
    public String timeFilterMode;

    public boolean adjustToDepTimespan() {
        return this.timeFilterMode == null || ObjectUtil.equal((Object)this.timeFilterMode, (Object)TIME_FILTER_DEPLOYMENT_TIMESPAN);
    }

    public boolean hasApplications() {
        return EnvironmentsFilterInput.hasFilter(this.applications);
    }

    public boolean hasServers() {
        return EnvironmentsFilterInput.hasFilter(this.servers);
    }

    public boolean hasDeployments() {
        return EnvironmentsFilterInput.hasFilter(this.deployments);
    }

    public boolean hasDeterminantFilter() {
        boolean result = this.hasApplications() || this.hasDeployments() || this.hasServers();
        return result;
    }

    public static String toAppLabel(String app) {
        return APP_LABEL_PREFIX + app;
    }

    public static boolean isLabelApp(String app) {
        return app.startsWith(APP_LABEL_PREFIX);
    }

    public static String getLabelAppName(String value) {
        if (value == null || !EnvironmentsFilterInput.isLabelApp(value)) {
            return value;
        }
        return value.substring(APP_LABEL_PREFIX.length());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EnvironmentsFilterInput)) {
            return false;
        }
        EnvironmentsFilterInput other = (EnvironmentsFilterInput)((Object)obj);
        return ObjectUtil.equal((Object)this.applications, (Object)other.applications) && ObjectUtil.equal((Object)this.deployments, (Object)other.deployments) && ObjectUtil.equal((Object)this.servers, (Object)other.servers);
    }
}

