/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.ViewInput;
import com.takipi.integrations.functions.annotations.Param;
import java.util.Collection;
import java.util.Collections;

public abstract class EventFilterInput
extends ViewInput {
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional comma delimited string array of deployment names to select all objects introduced by \na target set of deployments", defaultValue="")
    public String introducedBy;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional comma delimited array of type identifier to select all object of a specific type\n\tEach value can be one of the following :\n\t1.The type name of the object. Possible values include: \"Logged Error, \"Logged Warning,\n\t2. \"Uncaught Exception, Caught Exception, \"Swallowed Exception\", \"Timer\". \n\tThe simple name of an exception class. Must be preceded by a double dash ('--'). \n\t3. The name of a category as defined in https://git.io/fpPT0, or as added via the Settings dashboard.\n\tMust be preceded by a dash ('-').\n\tThe logical relationship between the values in the types array is a logical AND which means\n\tan object must pass all of the selectors to specified to be selected. \n", defaultValue="")
    public String types;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional comma delimited list of labels names the event must match to be selected. It is enough for the event to match at least one of the labels specified to be selected", defaultValue="")
    public String labels;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional string value list containing a value in the format of class.method.\nIf the value is matched against the error_location of a target event, it is selected.", defaultValue="")
    public String eventLocations;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional regex pattern applied to each of the target event's labels. If one of the labels match the regex pattern the event is selected.", defaultValue="")
    public String labelsRegex;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional String value containing a ISO 8601 date time value. For the object to be selected its first_seen attribute must be later than the date specified.", defaultValue="")
    public String firstSeen;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional string value containing a term that must be contained in a target event's error location (class or method name), entry point (class or method name), message or type for it to be selected. The value '<term>' is ignored.", defaultValue="")
    public String searchText;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional list of event types (as specified by the types array, excluding exception names and categories) that a target event must match to be selected. This filter is applied as a logical AND to that specified by the types filter.", defaultValue="")
    public String allowedTypes;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="An optional string value that must be contained in the event's entry point (class or name) for it to be selected.", defaultValue="")
    public String transactionSearchText;

    public String getSearchText() {
        if (this.searchText == null || this.searchText.equals("<term>")) {
            return null;
        }
        return this.searchText;
    }

    public boolean hasEventFilter() {
        if (this.introducedBy != null && this.introducedBy.length() > 0) {
            return true;
        }
        if (this.types != null && this.types.length() > 0) {
            return true;
        }
        if (this.labels != null && this.labels.length() > 0) {
            return true;
        }
        if (this.labelsRegex != null && this.labelsRegex.length() > 0) {
            return true;
        }
        if (this.firstSeen != null && this.firstSeen.length() > 0) {
            return true;
        }
        return this.hasTransactions();
    }

    public boolean hasIntroducedBy() {
        return EventFilterInput.hasFilter(this.introducedBy);
    }

    public Collection<String> getIntroducedBy(String serviceId) {
        if (this.introducedBy == null) {
            return Collections.emptySet();
        }
        return EventFilterInput.getServiceFilters(this.introducedBy, serviceId, true);
    }

    public Collection<String> geLabels(String serviceId) {
        if (this.labels == null) {
            return Collections.emptySet();
        }
        return EventFilterInput.getServiceFilters(this.labels, serviceId, true);
    }
}

