/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.BaseEventVolumeInput;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.common.util.ArrayUtil;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;
import java.util.Arrays;
import java.util.List;

@Function(name="events", type=Function.FunctionType.Table, description="This function populates a table containing information about a list of events.", example="events({\"fields\":\"link,type,entry_point,introduced_by,message,\n error_location,stats.hits,rate,first_seen\",\"view\":\"$view\",\n \"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\",\n \"applications\":\"$applications\",\"servers\":\"$servers\",\"deployments\":\"$deployments\",\n \"volumeType\":\"all\",\"maxColumnLength\":80, \"types\":\"$type\",\n \"pointsWanted\":\"$pointsWanted\",\"transactions\":\"$transactions\", \n \"searchText\":\"$search\"})\n", image="https://drive.google.com/file/d/12CVPNc-FDBhWOpofo5Ofatjo-zhHo8qj/view?usp=sharing", isInternal=false)
public class EventsInput
extends BaseEventVolumeInput {
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="A comma delimited list of attributes defined in: https://doc.overops.com/reference#get_services-env-id-events-event-id that can be used to define the columns within the result table. Additional available fields described below.id:id OverOps assigned ID for this unique event \nsummary: short text summary of the event \ntype: the type of event: Uncaught Exception, Swallowed Exception, Logged Error,.. \nname: The name of exception in case of exception (i.e. NullPointerException) otherwise the type\nmessage: The event's message if available\nfirst_seen: timestamp of when this unique even was first seen in this env\nerror_location: the code location within app code (e.g. acme.foo()) from which this even originiates \nentry_point_name: the first frame within the event's call stack which falls within app code (e.g. myServlet.goGet()). \nerror_origin: the frame in which this event took place, even if originating from within 3rd party of framecode code \nintroduced_by: the deployment name in which this event was first seen \nlabels: a comma delimited array of labels applied to this event \nsimilar_event_ids: a list of OverOps assigned Ids to events originating from the same code location but may have diff code entry points \nis_rethrow: is this an exception that is a rethrow of another exception within the code \njira_issue_url: the URL of an issue assigned to this event \nstats.hits: the number of times this event has happened \nstats.invocations: the number of times the code location method has been invoked \nenv_id: the event's env ID (e.g S12345)\ntypeMessage: a field containing a combination of the event type and message\njira_state: returns 1 if the event has a ticket assigned\nrate: the event rate hits / invocations\nrate_desc: a text description of the event rate\ndescription: a text description of the error location, containing optional tier information\nrate_delta: a value showing the change between the event rate in the selected timeframe and the baseline\nlast_seen: a value showing  when this event was first observed\nrate_delta_desc: a value describing the change between the event rate in the selected timeframe and the baseline\nrank: the order of this event within the returned list, based on its severity compared to other events within the return list\nentry_point_name: the simple name of the event entry point class name\n", defaultValue="")
    public String fields;
    public static final String EVENTS_SERIES = "events_series";
    public static final String JIRA_LABEL = "JIRA";
    public static final String ENV_ID = "env_id";
    public static final String ID = "id";
    public static final String SUMMARY = "summary";
    public static final String NAME = "name";
    public static final String MESSAGE = "message";
    public static final String TYPE = "type";
    public static final String FIRST_SEEN = "first_seen";
    public static final String ERROR_LOCATION = "error_location";
    public static final String ERROR_ORIGIN = "error_origin";
    public static final String INTRODUCED_BY = "introduced_by";
    public static final String HITS = "stats.hits";
    public static final String INVOCATIONS = "stats.invocations";
    public static final String LABELS = "labels";
    public static final String SIMILAR_EVENT_UDS = "similar_event_ids";
    public static final String IS_RETHROW = "is_rethrow";
    public static final String LINK = "link";
    public static final String TYPE_MESSAGE = "typeMessage";
    public static final String JIRA_STATE = "jira_state";
    public static final String JIRA_ISSUE_URL = "jira_issue_url";
    public static final String STACK_FRAMES = "stack_frames";
    public static final String RATE = "rate";
    public static final String RATE_DESC = "rate_desc";
    public static final String DESCRIPTION = "description";
    public static final String RATE_DELTA = "rate_delta";
    public static final String LAST_SEEN = "last_seen";
    public static final String RATE_DELTA_DESC = "rate_delta_desc";
    public static final String RANK = "rank";
    public static final String ENTRY_POINT_NAME = "entry_point_name";
    public static final List<String> DEFAULT_FIELDS = Arrays.asList("env_id", "id", "summary", "name", "message", "type", "first_seen", "error_location", "error_origin", "introduced_by", "stats.hits", "stats.invocations", "labels", "similar_event_ids", "is_rethrow", "link", "typeMessage", "jira_state", "jira_issue_url", "rate", "rate_desc", "description", "rate_delta", "last_seen", "rate_delta_desc", "rank", "entry_point_name");
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"hits", "invocations", "all"}, defaultValue="all", description=" An optional value to control the volume data retrieved for objects in this query. If \"hits\" is specified,\n\"N/A\" will be returned for all values of the \"rate\" field (if selected).")
    public ValidationUtil.VolumeType volumeType;
    @Param(type=Param.ParamType.Number, advanced=false, literals={}, defaultValue="0", description="An optional value controlling the max string length of the message and typeMessage columns.")
    public int maxColumnLength;
    @Param(type=Param.ParamType.Number, advanced=false, literals={}, defaultValue="0", description="An optional value controlling the max string length of the transaction and location columns.")
    public int maxClassLength;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, defaultValue="false", description="Controls whether events with the same code location but different entry points are grouped together. True to skip grouping")
    public boolean skipGrouping;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, defaultValue="false", description="Controls whether events should break their stats by app .true to skip breakdown")
    public boolean appBreakdown;
    @Param(type=Param.ParamType.Number, advanced=false, literals={}, defaultValue="0", description="An optional limit on the number of rows returned. Zero to ignore")
    public int maxRows;
    public static final String Grid = "Grid";
    public static final String SingleStat = "SingleStat";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Grid", "SingleStat"}, defaultValue="all", description=" The type of output returned by this function:\nGrid: Output data in grid format\nSingleStat: Output a single stat denoting the number of events (rows) returned by this function")
    public String outputMode;

    public List<String> getFields() {
        if (this.fields == null || this.fields.isEmpty()) {
            return DEFAULT_FIELDS;
        }
        String[] array = ArrayUtil.safeSplitArray(this.fields, ARRAY_SEPERATOR, true);
        return Arrays.asList(array);
    }

    public String getOutputMode() {
        if (this.outputMode == null || this.outputMode.isEmpty()) {
            return Grid;
        }
        return this.outputMode;
    }
}

