/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.takipi.api.client.functions.output.QueryResult;
import com.takipi.api.client.request.BaseRequest;
import com.takipi.api.client.util.settings.ServiceSettingsData;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.integrations.functions.annotations.Function;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public abstract class FunctionInput
extends BaseRequest
implements ApiGetRequest<QueryResult> {
    public static final String SERVICE_SEPERATOR_RAW = ":";
    public static final String SERVICE_SEPERATOR = ": ";
    public static final String GRAFANA_SEPERATOR_RAW = "|";
    public static final String GRAFANA_SEPERATOR = Pattern.quote("|");
    public static final String ARRAY_SEPERATOR_RAW = ",";
    public static final String GRAFANA_VAR_PREFIX = "$";
    public static final String TERM = "<term>";
    public static final String ALL = "All";
    public static final String NONE = "None";
    public static final List<String> VAR_ALL = Arrays.asList("*", "All", "All".toLowerCase(), "None", "None".toLowerCase());
    public static final String ARRAY_SEPERATOR = Pattern.quote(",");
    public static final String[] NO_LITERALS = new String[0];
    public static final String Week = "Week";
    public static final String Day = "Day";
    public static final String Hour = "Hour";
    public static final List<String> INTERVALS = Arrays.asList("Week", "Day", "Hour");
    public TimeFormat timeFormat;
    public String query;
    protected static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public TimeFormat getTimeFormat() {
        if (this.timeFormat == null) {
            return TimeFormat.EPOCH;
        }
        return this.timeFormat;
    }

    public static Function getFunctionAnnotation(Class<?> functionClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = functionClass.getDeclaredAnnotations()) {
            if (!(annotation instanceof Function)) continue;
            return (Function)annotation;
        }
        return null;
    }

    public static List<String> getFunctionNames(Class<?> functionClass) {
        Function function = FunctionInput.getFunctionAnnotation(functionClass);
        if (function == null) {
            throw new IllegalStateException("No function name available for " + functionClass.getClass());
        }
        String name = function.name();
        String[] parts = name.split(ServiceSettingsData.ARRAY_SEPERATOR);
        return Arrays.asList(parts);
    }

    public String urlPath() {
        return "/oo-as-influx/query";
    }

    public Class<QueryResult> resultClass() {
        return QueryResult.class;
    }

    public String[] queryParams() throws UnsupportedEncodingException {
        List<String> names = FunctionInput.getFunctionNames(((Object)((Object)this)).getClass());
        String json = gson.toJson((Object)this);
        StringBuilder function = new StringBuilder();
        function.append(names.get(0));
        function.append("(");
        function.append(json);
        function.append(")");
        String param = FunctionInput.encode((String)function.toString());
        String[] params = new String[]{"q=" + param};
        return params;
    }

    public static enum TimeFormat {
        EPOCH,
        ISO_UTC;

    }
}

