/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.VolumeInput;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;
import java.util.regex.Pattern;

@Function(name="groupBy", type=Function.FunctionType.Table, description=" This function enables the user return event volume data that is \"grouped\" by a certain attribute\n of the events selected.", example="groupBy({\"type\":\"sum\",\"field\":\"introduced_by\",\"limit\":5,\"volumeType\":\"all\",\n \"view\":\"All Events\",\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\",\n \"applications\":\"$applications\",\"servers\":\"$servers\",\n \"types\":\"Logged Error|Swallowed Exception|Logged Warning|Uncaught Exception|HTTP Error\",\n \"interval\":\"$__interval\"})", image="https://drive.google.com/file/d/1iucN3zx2MSubKZx5I7UuJPs6dfB7P82F/view?usp=sharing", isInternal=false)
public class GroupByInput
extends VolumeInput {
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String LABEL = "labels";
    public static final String ENTRY_POINT = "entryPoint";
    public static final String INTRODUCED_BY = "introduced_by";
    public static final String APPLICATION = "application";
    public static final String SERVER = "server";
    public static final String DEPLOYMENT = "deployment";
    public static final String GROUP_BY_SERIES = "group_by";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"name", "location", "entryPoint", "introduced_by", "labels", "application", "server", "deployment"}, defaultValue="application", description=" The attribute by which to group volumes, can be any one of the values: \ntype: Group by event types (e.g. Logged Error,Swallowed Exception,..)\nname: Group by event names (e.g. Logged Error, NullPointerException,..)\nlocation: Group by event locations (e.g classA.foo1, classB.foo2,..)\nentryPoint: Group by event entry points (e.g ServeletA.doGet, ServeletB.doGet,..)\nintroduced_by: Group event volume by application (e.g. Broker, Client, Bidder,..)\nlabels: Group event volume by labels (e.g. Jira, Critical,..)\napplication: Group event volume by application (e.g. Broker, Client, Bidder,..)\nserver: Group events by the deployment in they occurred (e.g. v1.1, v1.2, v1.3,..). An event may be introduced\n\tin a previous deployment (e.g. v1.3 which will match its introduced_by attribute) but surge due to\n\tcode or infrastructure changes in a subsequent deployment (e.g v1.5)deploymentGroup events by the deployment in they occurred (e.g. v1.1, v1.2, v1.3,..). An event may be introduced\nin a previous deployment (e.g. v1.3 which will match its introduced_by attribute) but surge due to\ncode or infrastructure changes in a subsequent deployment (e.g v1.5).\n/")
    public String field;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, defaultValue="false", description="Control whether to create individual columns for each of the volume types returned by this query")
    public boolean addTags;
    @Param(type=Param.ParamType.Number, advanced=false, literals={}, defaultValue="0", description="limit the number of applications / deployments / servers by which event volume is grouped to\n\t * the most recent <limit> deployments, or the the applications / servers which have the most event volume.\n")
    public int limit;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, defaultValue="1d", description="Set the time interval by which points in the returned time series are spaced. For example,\nan interval of 1d, means that a points containing the aggregated volume will be returned for each\nday within the time span (defined by the timeFilter parameter) executes.")
    public String interval;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, defaultValue="", description="A regex pattern used to filter in / out any value returned as the row name of each of the returned groups.\nFor example, if the function is used to group event volume by application and the invoker \nwould like to return rows for applications whose name starts with \"microservice\", the ^microservice regex\ncan be provided. The same can be used for labels, deployments, servers and more.\n")
    public String regexFilter;
    private Pattern patternFilter;

    public Pattern getPatternFilter() {
        if (this.regexFilter == null) {
            return null;
        }
        if (this.patternFilter != null) {
            return this.patternFilter;
        }
        this.patternFilter = Pattern.compile(this.regexFilter);
        return this.patternFilter;
    }
}

