/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.GraphLimitInput;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;

@Function(name="regressionGraph", type=Function.FunctionType.Graph, description="This function returns a list of time series data depicting volume increases within a target set of events.\n The algorithm used to decided which events to include is defined the Settings dashboard.\n", example="regressionGraph({\"type\":\"sum\",\"graphType\":\"view\",\"volumeType\":\"all\",\"view\":\"$view\",\n\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\", \n\"applications\":\"$applications\", \"deployments\":\"$deployments\",\"servers\":\"$servers\",\n\"pointsWanted\":\"$pointsWanted\", \"types\":\"$type\",\"limit\":3,\n\"searchText\":\"$search\", \"graphType\":\"Absolute\"})", image="", isInternal=false)
public class RegressionGraphInput
extends GraphLimitInput {
    public static final String NEW_ISSUES = "NewIssues";
    public static final String REGRESSIONS = "Regressions";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"NewIssues", "Regressions"}, defaultValue="Regressions", description="Control the type of regressions returned by this graph. Default is Increasing / Regressed events.\nNewIssues: return times series for new issues\nRegressions: return times series for increasing / regressed issues")
    public String regressionType;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="A string postfix that would be added to the series names of all time series whose increase\nis deemed to be severe. For example, a P1 suffix can be added to each time series name whose volume increase\n is deemed severe.", defaultValue="")
    public String sevSeriesPostfix;
    public static final String ABSOLUTE = "Absolute";
    public static final String PERCENTAGE = "Percentage";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Absolute", "Percentage"}, defaultValue="Percentage", description="The value of each Y point returned by the time series results of this function\nAbsolute: The Y value of each point will denote the volume data of the event at that given point\nPercentage: The Y value of each point will denote the ratio between event volume and calls into the event location at that given point")
    public String graphType;
    public String timeFilterVar;

    public String getGraphType() {
        if (this.graphType == null || this.graphType.isEmpty()) {
            return PERCENTAGE;
        }
        return this.graphType;
    }
}

