/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.EventsInput;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.common.util.CollectionUtil;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Function(name="regressions", type=Function.FunctionType.Table, description=" A function returning a table, graph or single stat relating to the number of new and increasing issues\nwithin a target set of events. The determination of which events have regressed is governed by the regression\nconfiguration in the Settings dashboard.", example="Example query to return table:\nregressions({\"fields\":\"link,type,entry_point,introduced_by,severity,regression,\ntypeMessage,error_location,stats.hits,rate,regDelta,first_seen,id\", \n\"render\":\"Grid\", \"regressionTypes\":\"Regressions,SevereRegressions\", \n\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\",\n\"applications\":\"$applications\",\"servers\":\"$servers\",\"deployments\":\"$deployments\",\n\"view\":\"$view\",\"maxColumnLength\":90,\"pointsWanted\":\"$pointsWanted\",\"\n types\":\"$type\",\"searchText\":\"$search\"})\nExample query for single stat:\nregressionReport({\"timeFilter\":\"$timeFilter\", \"environments\":\"$environments\",\n\"applications\":\"$applications\",\"servers\":\"$servers\",\"deployments\":\"$deployments\",\n\"view\":\"$view\",\"transactions\":\"$transactions\",\"pointsWanted\":\"$pointsWanted\",\n\"transactionPointsWanted\":\"$transactionPointsWanted\",\"types\":\"$type\",\n\"render\":\"SingleStat\"})", image="https://drive.google.com/file/d/1n6CVDqhwr0cz6C1p0AbMtAkontVJ1M0P/view?usp=sharing,https://drive.google.com/file/d/1PZHd27rVwt60pqcRIybgdYJ5qPSQQWB3/view?usp=sharing,https://drive.google.com/file/d/1Nb1FEXTxoyXAjlwxXNfq8GkjsJYYYHTF/view?usp=sharing", isInternal=false)
public class RegressionsInput
extends EventsInput {
    public static int MAX_TOOLTIP_ITEMS = 5;
    public static final String SEVERE_NEW_ISSUE_REGRESSIONS = "SevereNewIssues";
    public static final String NEW_ISSUE_REGRESSIONS = "NewIssues";
    public static final String SEVERE_INC_ERROR_REGRESSIONS = "SevereRegressions";
    public static final String INC_ERROR_REGRESSIONS = "Regressions";
    public static final List<String> REGRESSION_TYPES = Arrays.asList("SevereNewIssues", "NewIssues", "SevereRegressions", "Regressions");
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"SevereNewIssues", "NewIssues", "SevereRegressions", "Regressions"}, defaultValue="Regressions", description="Control the type of regressions returned by this graph. Default is Increasing / Regressed events.\nSevereNewIssues: A severe new issue detected within the context of this regression report\nNewIssues: A new issue detected within the context of this regression report\nSevereRegressions: A severe regression detected within the context of this regression report\nRegressions: A regression detected within the context of this regression report")
    public String regressionTypes;
    public static final String SINGLE_STAT = "SingleStat";
    public static final String SINGLE_STAT_DESC = "SingleStatDesc";
    public static final String SINGLE_STAT_COUNT = "SingleStatCount";
    public static final String SINGLE_STAT_VOLUME = "SingleStatVolume";
    public static final String SINGLE_STAT_VOLUME_TEXT = "SingleStatVolumeText";
    public static final String GRID = "Grid";
    public static final String GRAPH = "Graph";
    public static final String FEED = "Feed";
    public static final List<String> SINGLE_STATS = Arrays.asList("SingleStat", "SingleStatDesc", "SingleStatCount", "SingleStatVolume", "SingleStatVolumeText");
    public static final String REGRESSIONS_SERIES = "regressions_series";
    public static final String REGRESSION_TYPE = "regression_type";
    public static final String REG_DESC = "reg_desc";
    public static final String REGRESSION = "regression";
    public static final String REG_DELTA = "reg_delta";
    public static final String SEVERITY = "severity";
    public static final int SEVERITY_P1 = 2;
    public static final int SEVERITY_P2 = 1;
    public static final List<String> REGRESSION_FIELDS = new ArrayList<String>(EventsInput.DEFAULT_FIELDS);
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"SingleStat", "SingleStatDesc", "SingleStatCount", "SingleStatVolume", "SingleStatVolumeText", "Grid", "Graph", "Feed"}, defaultValue="Grid", description="Control the type of output to return from the function\nSingleStat: return a single stat value\nSingleStatDesc: return a desc of the single stat value\nSingleStatCount: return a the count of events returned\nSingleStatVolume: return the volume of events returned\nSingleStatVolumeText: return a string value of the volume of events returned\nGrid: return a table with each row depicting a new or increasing error.\n\tadditional available fields are:\n\treg_delta: value of the regression rate\tregression: description of the regression rate\tregression: description of the regression\treg_desc: Text value for the severity of the regression.\n\t\tIf the issue is severe = 2\n\t\tIf the issue is non-severe = 1\n\t\tIf the issue is not new or regressed = 0;Graph: This mode is only supported if the function is invoked to produce a reliabilty report,\n where each point depicts a key value from the report\nFeed:")
    public String render;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description=" An optional string format to be used when returning a single stat value. \n A decimal %d value will be passed into the string format", defaultValue="")
    public String singleStatFormat;
    @Param(type=Param.ParamType.Object, advanced=true, literals={}, description="An optional regressions objects to be used to programmatically pass regression inputs into the function.If no value is provided the settings for the env are used", defaultValue="")
    public RegressionInput regressionInput;

    public String getRenderMode() {
        if (this.render == null) {
            return GRID;
        }
        return this.render;
    }

    public boolean isSingleStat() {
        return SINGLE_STATS.contains(this.render);
    }

    public boolean newOnly() {
        Collection<String> regressionTypes = this.getRegressionTypes();
        return RegressionsInput.newOnly(regressionTypes);
    }

    public static boolean newOnly(Collection<String> regressionTypes) {
        if (CollectionUtil.safeIsEmpty(regressionTypes)) {
            return false;
        }
        boolean result = !regressionTypes.contains(INC_ERROR_REGRESSIONS) && !regressionTypes.contains(SEVERE_INC_ERROR_REGRESSIONS);
        return result;
    }

    public Collection<String> getRegressionTypes() {
        if (this.regressionTypes == null) {
            return Collections.emptyList();
        }
        String[] parts = this.regressionTypes.split(ARRAY_SEPERATOR);
        ArrayList<String> result = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (!REGRESSION_TYPES.contains(part)) continue;
            result.add(part);
        }
        return result;
    }

    static {
        REGRESSION_FIELDS.addAll(Arrays.asList(REGRESSION_TYPE, SEVERITY, REG_DELTA, REGRESSION, REG_DESC));
    }
}

