/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.GraphInput;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;

@Function(name="reliabilityKpiGraph,ReliabilityKpiGraph", type=Function.FunctionType.Table, description=" A function charting a target reliability KPI for a selected set of apps. KPIs include:\nreliability score, error volumes, new errors, increasing errors and more. The out put\ncan be set to chart results over time, grouping them by set report intervals (e.g. 1d, 7d,..)\nor produce a single average value for each scored application.", example="ReliabilityKpiGraph({\"volumeType\":\"all\",\"view\":\"$view\",\n\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\", \n\"applications\":\"$applications\", \"servers\":\"$servers\",\n\"types\":\"$type\",\"limit\":\"$limit\", \n\"reportInterval\":\"24h\", \"kpi\":\"$kpi\"}) ", image="Screenshot: https://drive.google.com/file/d/1kSUO1SE5gOqVCYb5eKrsWYxi4PJNbs9J/view?usp=sharing", isInternal=false)
public class ReliabilityKpiGraphInput
extends GraphInput {
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description=" The kpi to chart: \nNewErrors: chart the number of new issues\nSevereNewErrors: chart the number of severe increasing errors \nErrorIncreases: chart the number of increasing errors \nSevereErrorIncreases: chart the number of severe increasing errors \nErrorRate: the URL without a port value  (i.e 443)\nSlowdowns: chart the number of transaction slowdowns\nSevereSlowdowns: chart the number of severe transaction slowdowns\nFailRateDelta: chart the transaction failure rate delta\nFailRateDesc: chart the transaction failure rate delta description\nScore: chart the reliability score of the target app, deployment, tier\nScoreDesc: chart the score desc of the target app, deployment, tier", defaultValue="")
    public String kpi;
    @Param(type=Param.ParamType.Number, advanced=false, literals={}, description="The max number of apps to chart", defaultValue="0")
    public int limit;
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Day", "Week", "Hour"}, description="The interval by which to group data (e.g. 1d, 7d,..)", defaultValue="Day")
    public String reportInterval;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description="Control whether to aggregate all apps kpis, or break down by the report interval\nfor trends over time", defaultValue="false")
    public boolean aggregate;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description="Control whether too chart scores as 100 - <score>", defaultValue="false")
    public boolean deductFrom100;

    public String getReportInterval() {
        if (this.reportInterval == null || this.reportInterval.isEmpty()) {
            return "Day";
        }
        return this.reportInterval;
    }
}

