/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.RegressionsInput;
import com.takipi.api.client.util.performance.calc.PerformanceState;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Function(name="reliabilityReport,regressionReport", type=Function.FunctionType.Table, description="A function returning a report for a a target set of applications, deployments or tiers (i.e. categories)\nlisting an possible new errors, increases (i.e. regressions) and slowdowns. The function can return\neither a tabular report or a chart, where a key selected value from each row is used as the Y value\nand the name of the target app, deployment, tier is used as the X value. The decisions regarding\nwhich events are new, regressing and which transactions have slowdowns are governed by the \nregression and transaction setting available in the Settings dashboard.", example="Example query for table:\nregressionReport({\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\",\n\"applications\":\"$applications\",\"servers\":\"$servers\",\"deployments\":\"$deployments\",\n\"view\":\"$view\",\"pointsWanted\":\"$pointsWanted\", \"transactionPointsWanted\":\"$transactionPointsWanted\",\n\"types\":\"$type\", \"render\":\"Grid\", \"mode\":\"Tiers\", \"limit\":\"$limit\", \n\"sevAndNonSevFormat\":\"%d  (%d p1)\", \"sevOnlyFormat\":\"%d p1\"})\nExample query for graph:\nregressionReport({\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\",\n\"applications\":\"$applications\",\"servers\":\"$servers\",\"deployments\":\"$deployments\",\n\"view\":\"$view\",\"pointsWanted\":\"$pointsWanted\", \"transactionPointsWanted\":\"$transactionPointsWanted\",\n\"types\":\"$type\", \"render\":\"Graph\", \"mode\":\"Deployments\", \"limit\":\"$limit\",\n\"graphType\":\"$graphType\"})", image="Screenshot: https://drive.google.com/file/d/1aEXcfTGC9OfNaJvsEeRptqp2o1czd0SW/view?usp=sharing\n", isInternal=false)
public class ReliabilityReportInput
extends RegressionsInput {
    public static final String APPLICATIONS_REPORT = "Applications";
    public static final String APPS_EXTENDED_REPORT = "Apps_Extended";
    public static final String DEPLOYMENTS_REPORT = "Deployments";
    public static final String TIERS_REPORT = "Tiers";
    public static final String TIERS_EXTENDED_REPORT = "Tiers_Extended";
    public static final String TIMELINE_REPORT = "Timeline";
    public static final String TIMELINE_EXTENDED_REPORT = "Timeline_Extended";
    public static final String DEFAULT_REPORT = "Default";
    public static final String NEW_ERRORS_KPI = "NewErrors";
    public static final String SEVERE_NEW_ERRORS_KPI = "SevereNewErrors";
    public static final String ERROR_INCREASES_KPI = "ErrorIncreases";
    public static final String SEVERE_ERROR_INCREASES_KPI = "SevereErrorIncreases";
    public static final String SLOWDOWNS_KPI = "Slowdowns";
    public static final String SEVERE_SLOWDOWNS_KPI = "SevereSlowdowns";
    public static final String ERROR_VOLUME_KPI = "ErrorVolume";
    public static final String ERROR_COUNT_KPI = "ErrorCount";
    public static final String ERROR_RATE_KPI = "ErrorRate";
    public static final String FAIL_RATE_DELTA_KPI = "FailRateDelta";
    public static final String FAIL_RATE_DESC_KPI = "FailRateDesc";
    public static final String SCORE_KPI = "Score";
    public static final String SCORE_DESC_KPI = "ScoreDesc";
    public static final List<String> KPIS = Arrays.asList("NewErrors", "SevereNewErrors", "ErrorIncreases", "SevereErrorIncreases", "Slowdowns", "SevereSlowdowns", "ErrorRate", "ErrorVolume", "ErrorCount", "FailRateDelta", "FailRateDesc", "Score", "ScoreDesc");
    public static final String RELIABITY_REPORT_SERIES = "reliability_report";
    public static final String REGRESSION_SERIES = "relability_report_regressions";
    public static final String ERRORS_SERIES = "reliability_report_errors";
    public static final String FAILURES_SERIES = "reliability_report_failures";
    public static final String SLOWDOWN_SERIES = "reliability_reporty_slowdown";
    public static final List<String> SERIES_TYPES = Arrays.asList("reliability_report", "relability_report_regressions", "reliability_report_errors", "reliability_report_failures", "reliability_reporty_slowdown");
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description="Control whether to report only on live deployment in Deployment report mode", defaultValue="false")
    public boolean liveDeploymentsOnly;
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Day", "Week", "Hour"}, description="Control the report interval in Timeline mode", defaultValue="Day")
    public String reportInterval;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description=" Control whether to add am \"Application\" tier  in Tiers report mode", defaultValue="false")
    public boolean addAppTier;
    public static final String KPIS_DESC = "NewErrors: chart the number of new issues\nSevereNewErrors: chart the number of severe increasing errors \nErrorIncreases: chart the number of increasing errors \nSevereErrorIncreases: chart the number of severe increasing errors \nErrorRate: the URL without a port value  (i.e 443)\nSlowdowns: chart the number of transaction slowdowns\nSevereSlowdowns: chart the number of severe transaction slowdowns\nFailRateDelta: chart the transaction failure rate delta\nFailRateDesc: chart the transaction failure rate delta description\nScore: chart the reliability score of the target app, deployment, tier\nScoreDesc: chart the score desc of the target app, deployment, tier";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"NewErrors", "SevereNewErrors", "ErrorIncreases", "SevereErrorIncreases", "Slowdowns", "SevereSlowdowns", "ErrorRate", "FailRateDelta", "FailRateDesc", "Score", "ScoreDesc"}, defaultValue="Score", description="The specific kpi to chart \nNewErrors: chart the number of new issues\nSevereNewErrors: chart the number of severe increasing errors \nErrorIncreases: chart the number of increasing errors \nSevereErrorIncreases: chart the number of severe increasing errors \nErrorRate: the URL without a port value  (i.e 443)\nSlowdowns: chart the number of transaction slowdowns\nSevereSlowdowns: chart the number of severe transaction slowdowns\nFailRateDelta: chart the transaction failure rate delta\nFailRateDesc: chart the transaction failure rate delta description\nScore: chart the reliability score of the target app, deployment, tier\nScoreDesc: chart the score desc of the target app, deployment, tier")
    public String graphType;
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Applications", "Apps_Extended", "Deployments", "Tiers", "Tiers_Extended", "Timeline", "Timeline_Extended", "Default"}, defaultValue="Default", description="The target filters to report each row by: application, deployment or tier\nApplications: The report will return a row for each application in the environment, the report\n will list up to <limit> apps, sorted by the apps who have the highest volume of events\nApps_Extended:The report will return a row for each application in the environment with additional\ninformation about throughput and failure rates. The report\nwill list up to <limit> apps, sorted by the apps who have the highest volume of events\nDeployments: The report will return a row for the last <limit> deployments in the target envs.\nTiers, Tiers_ExtendedThe report will return a row for the last <limit> tiers in the target envs which \nhave the highest volume of events. If any key tiers are defiend in the Settings dashboard\nthey are used first.Tiers_Extended: the URL without a port value  (i.e 443)\nTimeline,Timeline_Extended:  The report will return a a single row each day within the timeframe with extended information\nDefault: The report will return a a single row for the target event set\n\n In grid mode the follwing fields are available to choose from: \nService: the env name for this row\nServiceId: the env ID for this row\nName: a human-readable name  of the target app/dep/tier\npreviousDepName: name of the deployment, the name of the deployment to be diff against\npreviousDepFrom: name of the deployment, the start of the deployment to be diff against\npreviousDepState: name of the deployment and a diff deployment exists = 1, otherwise 0\nTimelineDiffState: The field name of the row used to link the user to the diff of the current timeline interval and its prev one\nNewIssues: name of the row is a Value of any new issues in this row\nRegressions: name of the value of any regressions in this row\nSlowdowns: the value of any slowdowns in this row\nNewIssuesDesc: the Text description of new issues in this row\nRegressionsDesc: the Text description of regressions in this row\nSlowdownsDesc: the Text description of slowdowns in this row\nScore: the Reliability score for this row\nScoreDesc: text description of reliability score for this row\nTransactionVolume: transaction volume for this row\nTransactionCount:  transaction count for this row\nTransactionAvgResponse: transaction avg response for this row\nTransactionFailures: transaction failure volume\nTransactionVolumeDesc: transaction failure count description\nTransactionFailureCountDesc: transaction failure count description\nTransactionFailureCount: transaction failure unique count\nTransactionFailRate: transaction failure rate for this row\nTransactionFailRateDelta: transaction failure delta rate for this row\nErrorVolume: error count for this row\nErrorCountDesc: error count desc for this row\nErrorCount: error count for this row\nReliabilityState: overall reliability state\nFailureDesc: transaction failure rate description\nRelabilityDesc: app reliability state description\nStatusName: an app name + reliability state\nAlertStatus: an app / tier alert status\nAlertDesc: app / tier alert description\nAlertViewId: ID of view on which aler relating to this key have been set\nConnectedClients: number of connected clients of app\nConnectedClientsDesc: number of description of connected clients of app\nEventName: name of the message of a feed event\nEventDesc:  description of a feed event\nEventTypeDesc: description of a feed event type\nEventType: type for the current event feed item\nEventApp: app for the current event feed item\nDashboardId: name of the drill down dashboard for the current event feed item\nDashboardField: name of the drill down field within the drill down dashboard for the current event feed item\nDashboardValue: name of the drill down field value within the drill down dashboard for the current event feed item\n")
    public String mode;
    public ScoreType scoreType;
    @Param(type=Param.ParamType.Number, advanced=false, literals={}, description="The max number of rows / time series points to return", defaultValue="0")
    public int limit;
    @Param(type=Param.ParamType.Boolean, advanced=true, literals={}, description="Control whether non-key apps added to report are sorted by volume", defaultValue="false")
    public boolean queryAppVolumes;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="A comma delimited pair of numeric values used to define thresholds by which\nto choose a postfix for a score series based on the values set in postfixes", defaultValue="")
    public String thresholds;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="A comma delimited arrays of 3 postfix to be added to the series name. The post fix\nis selected based on if the reliability score is smaller than, in between or greater than the upper\nthreshold. For example if this is set to \"BAD,OK,GOOD\" and thresholds is \"70,85\"\na score below 70 will have the postfix \"BAD\" added to the series name, 80 will be\n\"OK\" and 90 will be \"GOOD\" ", defaultValue="")
    public String postfixes;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The string format used to present a row value containing both severe and non severe items\nwill receive the number of issues and the number of severe issues as string format %d parameters,\nfor example: \"%d  (%d p1)\"", defaultValue="%d  (%d p1)")
    public String sevAndNonSevFormat;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The string format used to present a row value containing non severe items\nwill receive the number of issues as string format %d parameter,\nfor example: \"%d issues", defaultValue="%d p1")
    public String sevOnlyFormat;
    public static final String SORT_ASCENDING = "Ascending";
    public static final String SORT_DESCENDING = "Descending";
    public static final String SORT_DEFAULT = "Default";
    @Param(type=Param.ParamType.Enum, advanced=true, literals={"Ascending", "Descending", "Default"}, defaultValue="Default", description="Control how rows are sorted")
    public String sortType;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="An optional comma delimited list of types to be used to calculate\nfailure types in extended app reporting mode. If no value if provided the types value\nis used.", defaultValue="")
    public String failureTypes;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="A comma delimited array used to visually annotate the reliability status of the key\nbased on the score ranges", defaultValue="\\xE2\\x9C\\x85,\\xE2\\x9A\\xA0\\xEF\\xB8\\x8F,\\xE2\\x9D\\x8C")
    public String statusPrefixes;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="A comma delimited array used to visually annotate the fail rate status of the key\n based on the score ranges", defaultValue="\\xE2\\x9C\\x85,\\xE2\\x9A\\xA0\\xEF\\xB8\\x8F,\\xE2\\x9D\\x8C")
    public String failRatePrefixes;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="A string postfix to be added to an app / tier name to denote it having alerts set", defaultValue="")
    public String alertNamePostfix;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="A comma delimited array in the form of X,Y, where X defines the threshold for a failed score\nand Y defines the threshold a successful score", defaultValue="70,85")
    public String scoreRanges;
    public static final String NEW_ERROR_FEED = "NewError";
    public static final String SEVERE_NEW_ERROR_FEED = "SevereNewError";
    public static final String INCREASING_ERROR_FEED = "IncreasingError";
    public static final String SEVERE_INCREASING_ERROR_FEED = "SevereIncreasingError";
    public static final String SLOWDOWN_FEED = "Slowdown";
    public static final String SEVERE_SLOWDOWN_FEED = "SevereSlowdown";
    public static List<String> FEED_TYPES = Arrays.asList("NewError", "SevereNewError", "IncreasingError", "SevereIncreasingError", "Slowdown", "SevereSlowdown");
    @Param(type=Param.ParamType.Enum, advanced=true, literals={"NewError", "SevereNewError", "IncreasingError", "SevereIncreasingError", "Slowdown", "SevereSlowdown"}, defaultValue="", description="Control the type of anomlies presented within the output feed\nNewError: predent new non severe errors\nSevereNewError: present severe errors\nIncreasingError: present errors whose volume has increased when compared to their baseline\nSevereIncreasingError: present severe errors whose volume has increased when compared to their baseline\nSlowdown: present Transactions whose response time has slown down comapred to their baseline \nSevereSlowdown: present Transactions whose response time has severly slown down comapred to their baseline\n")
    public String eventFeedTypes;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The id of the dashboard to which new errors drill into", defaultValue="MKvwYc7Wk")
    public String newErrorDashboardId;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The id of the dashboard to which inc errors drill into", defaultValue="WZ739NYmk")
    public String incErrorDashboardId;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The id of the dashboard to which slowdown events drill into", defaultValue="iHSORcymk")
    public String slowdownDashboardId;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The var name within the new errors dashboard to which an ARC link for this error will be set ", defaultValue="link")
    public String newErrorDashboardField;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The var name within the inc errors dashboard to which the code location this error will be set ", defaultValue="increasingErrors")
    public String incErrorDashboardField;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, description="The var name within the slowdowns dashboard to which the transaction name for this slowdown will be set ", defaultValue="transactions")
    public String slowdownDashboardField;
    @Param(type=Param.ParamType.Boolean, advanced=true, literals={}, description="Control whether to output additional series reliability_report_errors,reliability_report_failures,reliability_report_failures,relability_report_regressions detailing the contents of errors and slowdowns", defaultValue="false")
    public boolean outputDrillDownSeries;
    @Param(type=Param.ParamType.Boolean, advanced=true, literals={}, description="Control whether to request stack frames for new and increasing events", defaultValue="false")
    public boolean requestStackframes;
    public static final String SERVICE = "Service";
    public static final String SERVICE_ID = "ServiceId";
    public static final String KEY = "Key";
    public static final String KEY_NANE = "Name";
    public static final String PREV_DEP_NAME = "previousDepName";
    public static final String PREV_DEP_FROM = "previousDepFrom";
    public static final String PREV_DEP_STATE = "previousDepState";
    public static final String TIMELINE_DIFF_STATE = "TimelineDiffState";
    public static final String NEW_ISSUES = "NewIssues";
    public static final String REGRESSIONS = "Regressions";
    public static final String SLOWDOWNS = "Slowdowns";
    public static final String NEW_ISSUES_DESC = "NewIssuesDesc";
    public static final String REGRESSIONS_DESC = "RegressionsDesc";
    public static final String SLOWDOWNS_DESC = "SlowdownsDesc";
    public static final String SCORE = "Score";
    public static final String SCORE_DESC = "ScoreDesc";
    public static final String TRANSACTION_VOLUME = "TransactionVolume";
    public static final String TRANSACTION_COUNT = "TransactionCount";
    public static final String TRANSACTION_AVG_RESPONSE = "TransactionAvgResponse";
    public static final String TRANSACTION_RESPONSE_DELTA = "TransactionResponseDelta";
    public static final String TRANSACTION_FAILURES = "TransactionFailures";
    public static final String TRANSACTION_VOLUME_DESC = "TransactionVolumeDesc";
    public static final String TRANSACTION_FAIL_COUNT_DESC = "TransactionFailureCountDesc";
    public static final String TRANSACTION_FAILURES_COUNT = "TransactionFailureCount";
    public static final String TRANSACTION_FAIL_RATE = "TransactionFailRate";
    public static final String TRANSACTION_FAIL_RATE_DELTA = "TransactionFailRateDelta";
    public static final String ERROR_VOLUME = "ErrorVolume";
    public static final String ERROR_COUNT_DESC = "ErrorCountDesc";
    public static final String ERROR_COUNT = "ErrorCount";
    public static final String RELIABILITY_STATE = "ReliabilityState";
    public static final String TRANSACTION_FAIL_DESC = "FailureDesc";
    public static final String RELIABILITY_DESC = "RelabilityDesc";
    public static final String STATUS_NAME = "StatusName";
    public static final String ALERT_STATUS = "AlertStatus";
    public static final String ALERT_DESC = "AlertDesc";
    public static final String ALERT_VIEW_ID = "AlertViewId";
    public static final String CONNECTED_CLIENTS = "ConnectedClients";
    public static final String CONNECTED_CLIENTS_DESC = "ConnectedClientsDesc";
    public static final String EVENT_NAME = "EventName";
    public static final String EVENT_DESC = "EventDesc";
    public static final String EVENT_TYPE_DESC = "EventTypeDesc";
    public static final String EVENT_TYPE = "EventType";
    public static final String EVENT_APP = "EventApp";
    public static final String DASHBOARD_ID = "DashboardId";
    public static final String DASHBOARD_FIELD = "DashboardField";
    public static final String DASHBOARD_VALUE = "DashboardValue";
    public static final String FIELDS_DESC = "Service: the env name for this row\nServiceId: the env ID for this row\nName: a human-readable name  of the target app/dep/tier\npreviousDepName: name of the deployment, the name of the deployment to be diff against\npreviousDepFrom: name of the deployment, the start of the deployment to be diff against\npreviousDepState: name of the deployment and a diff deployment exists = 1, otherwise 0\nTimelineDiffState: The field name of the row used to link the user to the diff of the current timeline interval and its prev one\nNewIssues: name of the row is a Value of any new issues in this row\nRegressions: name of the value of any regressions in this row\nSlowdowns: the value of any slowdowns in this row\nNewIssuesDesc: the Text description of new issues in this row\nRegressionsDesc: the Text description of regressions in this row\nSlowdownsDesc: the Text description of slowdowns in this row\nScore: the Reliability score for this row\nScoreDesc: text description of reliability score for this row\nTransactionVolume: transaction volume for this row\nTransactionCount:  transaction count for this row\nTransactionAvgResponse: transaction avg response for this row\nTransactionFailures: transaction failure volume\nTransactionVolumeDesc: transaction failure count description\nTransactionFailureCountDesc: transaction failure count description\nTransactionFailureCount: transaction failure unique count\nTransactionFailRate: transaction failure rate for this row\nTransactionFailRateDelta: transaction failure delta rate for this row\nErrorVolume: error count for this row\nErrorCountDesc: error count desc for this row\nErrorCount: error count for this row\nReliabilityState: overall reliability state\nFailureDesc: transaction failure rate description\nRelabilityDesc: app reliability state description\nStatusName: an app name + reliability state\nAlertStatus: an app / tier alert status\nAlertDesc: app / tier alert description\nAlertViewId: ID of view on which aler relating to this key have been set\nConnectedClients: number of connected clients of app\nConnectedClientsDesc: number of description of connected clients of app\nEventName: name of the message of a feed event\nEventDesc:  description of a feed event\nEventTypeDesc: description of a feed event type\nEventType: type for the current event feed item\nEventApp: app for the current event feed item\nDashboardId: name of the drill down dashboard for the current event feed item\nDashboardField: name of the drill down field within the drill down dashboard for the current event feed item\nDashboardValue: name of the drill down field value within the drill down dashboard for the current event feed item\n";
    public static final List<String> DEFAULT_DEP_FIELDS = Arrays.asList("from", "to", "timeRange", "Service", "Key", "NewIssuesDesc", "RegressionsDesc", "SlowdownsDesc", "ScoreDesc", "previousDepName", "previousDepFrom", "Name", "NewIssues", "Regressions", "Slowdowns", "previousDepState", "Score");
    public static final List<String> DEFAULT_APP_FIELDS = Arrays.asList("from", "to", "timeRange", "Service", "Key", "NewIssuesDesc", "RegressionsDesc", "SlowdownsDesc", "ScoreDesc", "Name", "NewIssues", "Regressions", "Slowdowns", "Score");
    public static final List<String> DEFAULT_TIMELINE_FIELDS = Arrays.asList("from", "to", "timeRange", "Service", "Key", "NewIssuesDesc", "RegressionsDesc", "SlowdownsDesc", "ScoreDesc", "Name", "NewIssues", "Regressions", "Slowdowns", "TimelineDiffState", "Score");
    public static final List<String> DEFAULT_EXTENDED_FIELDS = Arrays.asList("from", "to", "timeRange", "Service", "Key", "ReliabilityState", "NewIssuesDesc", "RegressionsDesc", "SlowdownsDesc", "ScoreDesc", "FailureDesc", "RelabilityDesc", "AlertDesc", "TransactionFailureCountDesc", "ErrorCountDesc", "TransactionVolumeDesc", "ConnectedClientsDesc", "ServiceId", "AlertViewId", "Name", "StatusName", "AlertStatus", "Score", "NewIssues", "Regressions", "TransactionFailures", "TransactionFailureCount", "Slowdowns", "TransactionFailRate", "TransactionFailRateDelta", "ErrorVolume", "ErrorCount", "TransactionCount", "TransactionVolume", "TransactionAvgResponse", "ConnectedClients");
    public static final List<String> FEED_FIELDS = Arrays.asList("from", "to", "timeRange", "Service", "Key", "DashboardId", "DashboardField", "DashboardValue", "EventDesc", "EventTypeDesc", "EventType", "EventName", "EventApp");

    public static String getKpi(String kpi) {
        if (kpi == null || kpi.length() == 0) {
            return "Score";
        }
        String value = kpi.replace(" ", "");
        String result = !KPIS.contains(value) ? "Score" : value;
        return result;
    }

    public String getReportMode() {
        if (this.mode == null || this.mode.isEmpty()) {
            return "Default";
        }
        return this.mode;
    }

    public boolean isTiersReportMode() {
        return TIERS_REPORT.equals(this.mode) || TIERS_EXTENDED_REPORT.equals(this.mode);
    }

    public ScoreType getScoreType() {
        if (this.scoreType == null) {
            return ScoreType.Combined;
        }
        return this.scoreType;
    }

    public String getSortType() {
        if (this.sortType == null) {
            return "Default";
        }
        return this.sortType;
    }

    public String getFailureTypes() {
        if (this.failureTypes == null || this.failureTypes.isEmpty()) {
            if (this.types != null && !this.types.isEmpty()) {
                return this.types;
            }
            return "Critical Exceptions";
        }
        return this.failureTypes;
    }

    public static String getFeedEventType(String type) {
        switch (type) {
            case "NewIssues": {
                return NEW_ERROR_FEED;
            }
            case "SevereNewIssues": {
                return NEW_ERROR_FEED;
            }
            case "SevereRegressions": {
                return SEVERE_INCREASING_ERROR_FEED;
            }
            case "Regressions": {
                return INCREASING_ERROR_FEED;
            }
        }
        throw new IllegalStateException(String.valueOf(type));
    }

    public static String getFeedEventType(PerformanceState state) {
        switch (state) {
            case CRITICAL: {
                return SEVERE_SLOWDOWN_FEED;
            }
            case SLOWING: {
                return SLOWDOWN_FEED;
            }
            case OK: 
            case NO_DATA: {
                return null;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)state));
    }

    public Collection<String> getEventFeedTypes() {
        if (this.eventFeedTypes == null || this.eventFeedTypes.length() == 0) {
            return null;
        }
        Collection<String> values = ReliabilityReportInput.getServiceFilters(this.eventFeedTypes, null, true);
        HashSet<String> result = new HashSet<String>(values.size());
        for (String value : values) {
            String feedType = value.replace(" ", "");
            if (!FEED_TYPES.contains(feedType)) continue;
            result.add(feedType);
        }
        return result;
    }

    public static enum ReliabilityState {
        OK,
        Warning,
        Severe;

    }

    public static enum ScoreType {
        NewOnly(true, false),
        Regressions(true, false),
        Slowdowns(false, true),
        Combined(true, true);

        private final boolean includeRegressions;
        private final boolean includeTransactions;

        private ScoreType(boolean includeRegressions, boolean includeTransactions) {
            this.includeRegressions = includeRegressions;
            this.includeTransactions = includeTransactions;
        }

        public boolean includeSlowdowns() {
            return this.includeTransactions;
        }

        public boolean includeRegressions() {
            return this.includeRegressions;
        }
    }
}

