/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.BaseGraphInput;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;

@Function(name="transactionsGraph", type=Function.FunctionType.Graph, description="A function returning a set of times series depicting the volume of calls into a target set \nof entry points (i.e. transactions)", example="transactionsGraph({\"graphType\":\"view\",\"volumeType\":\"invocations\",\"view\":\"$view\",\n\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\", \"applications\":\"$applications\",\n\"deployments\":\"$deployments\",\"servers\":\"$servers\",\"aggregate\":true,\n\"seriesName\":\"Throughput\",\"pointsWanted\":\"$pointsWanted\",\"transactions\":\"$transactions\"})", image="https://drive.google.com/file/d/1i_9DjK-mugjsagBKh-ZuJb3G07AtcyH6/view?usp=sharing", isInternal=false)
public class TransactionsGraphInput
extends BaseGraphInput {
    public static final String AVG_TIME_GRAPH = "avg_time";
    public static final String INVOCATIONS_GRAPH = "invocations";
    public static final String ALL_GRAPH = "all";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"avg_time", "invocations", "all"}, defaultValue="avg_time", description="The volume type to be used for the Y value of each of the points in the time series: \navg_time: use the number of calls into the target transactions as the Y value\ninvocations: return time series for the number of calls AND the avg response time to complete calls into the target transactions as the Y value\nall: the complete URL to the OverOps backend REST endpoint including port (i.e. api.overops.com:443)\n")
    public String volumeType;
    public static final String AGGREGATE_YES = "Yes";
    public static final String AGGREGATE_NO = "No";
    public static final String AGGREGATE_AUTO = "Auto";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Yes", "No", "Auto"}, defaultValue="Auto", description="Controls whether the time series Y values for the matching transactions are merged into a single\n aggregate series: \nYes: aggregate the selected transactions into one series\nNo: split the selected transactions into multiple series\nAuto: aggregate the selected transactions into one series\nif the selection is a group or top transaction filter, otherwise split\n")
    public String aggregateMode;
    @Param(type=Param.ParamType.Number, advanced=false, literals={}, description="Control the max number of separate time series returned by this function if aggregate is set to false", defaultValue="0")
    public int limit;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="A comma delimited array of performance states, that a target transaction must meet in order to be returned\nby this function. Possible values are: \tOK, Slowing, Critical", defaultValue="")
    public String performanceStates;
    public static final String TIME_WINDOW_ACTIVE = "Active";
    public static final String TIME_WINDOW_BASELINE = "Baseline";
    public static final String TIME_WINDOW_ALL = "All";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Active", "Baseline", "All"}, defaultValue="Active", description="Control which time window points to use to calculate the weighted avg: \nActive: Use the avg response of the active time window as the Y value\nBaseline: Use the avg response of the baseline time window as the Y value\nAll: Add the avg response of the active and baseline time windows as the Y value\n")
    public String timeWindow;
    public String timeFilterVar;

    public String getAggregateMode() {
        if (this.aggregateMode == null || this.aggregateMode.isEmpty()) {
            return AGGREGATE_AUTO;
        }
        return this.aggregateMode;
    }

    public String getTimeWindow() {
        String result = this.timeWindow;
        if (result == null) {
            result = TIME_WINDOW_ACTIVE;
        }
        return result;
    }
}

