/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.BaseGraphInput;
import com.takipi.api.client.util.performance.calc.PerformanceState;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Function(name="transactionsList", type=Function.FunctionType.Table, description="A function returning a list of rows depicting the volume and rates of calls into \n event entry points (i.e. transactions). This function can return a list of objects used to\n populate table, or a single stat value used to populate a single stat widget", example="transactionsList({\"view\":\"$view\", \"timeFilter\":\"$timeFilter\",\n\"environments\":\"$environments\",\"applications\":\"$applications\",\"servers\":\"$servers\", \"deployments\":\"$deployments\", \n\"fields\":\"link,slow_delta,delta_description,from,to,timeRange,\nbaseline_calls,active_calls,transaction,invocations,avg_response,baseline_avg,error_rate,errors\",\n\"renderMode\":\"Grid\",\"types\":\"$transactionFailureTypes\",\"transactions\":\"$transactions\", \n\"searchText\":\"$searchText\", \"pointsWanted\":\"$transactionPointsWanted\"})", image="https://drive.google.com/file/d/1KFy__D3nhGi8HLvrKkiLfwT8YgIUmaN1/view?usp=sharing,https://drive.google.com/file/d/1A7eGLJIXvfUMHgvAcGEiY8uGTN1Xcn8X/view?usp=sharing", isInternal=false)
public class TransactionsListInput
extends BaseGraphInput {
    public static final String RENDER_SINGLE_STAT = "SingleStat";
    public static final String RENDER_SINGLE_STAT_DESC = "SingleStatDesc";
    public static final String RENDER_SINGLE_STAT_VOLUME = "SingleStatVolume";
    public static final String RENDER_SINGLE_STAT_AVG = "SingleStatAvg";
    public static final String RENDER_SINGLE_STAT_BASELINE_AVG = "SingleStatBaselineAvg";
    public static final String RENDER_SINGLE_STAT_FAILURES = "SingleStatFailures";
    public static final String RENDER_SINGLE_STAT_FAIL_RATE = "SingleStatFailureRate";
    public static final String RENDER_GRID = "Grid";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"SingleStat", "SingleStatDesc", "SingleStatVolume", "SingleStatAvg", "SingleStatBaselineAvg", "SingleStatFailures", "SingleStatFailureRate", "Grid"}, defaultValue="SingleStat", description="Control whether to return a list of rows or a single aggregated stat by this function: \nSingleStat: output the volume of transactions matching the target state (e.t. OK, Slowing, Critical)\nSingleStatDesc: output a tooltip description of transactions matching the target state (e.t. OK, Slowing, Critical)\nSingleStatVolume: output the volume of transactions\nSingleStatAvg: output a weighted avg of transaction response time\nSingleStatBaselineAvg: output a number of failures in the list\nSingleStatFailures: output a number of failures divided by number of invocations in the list\nSingleStatFailureRate: output a number of failures divided by number of invocations in the list\nGrid: output a row for each transaction")
    public String renderMode;
    public static final String LINK = "link";
    public static final String TRANSACTION = "transaction";
    public static final String TOTAL = "invocations";
    public static final String AVG_RESPONSE = "avg_response";
    public static final String TIME_COMSUMED = "time_consumed";
    public static final String SLOW_STATE = "slow_state";
    public static final String ERROR_RATE = "error_rate";
    public static final String ERRORS = "errors";
    public static final String ERROR_RATE_DELTA = "error_rate_state";
    public static final String ERROR_RATE_DELTA_STATE = "error_rate_delta_state";
    public static final String ERROR_RATE_DELTA_DESC = "error_rate_delta_desc";
    public static final String ERRORS_DESC = "error_description";
    public static final String DELTA_DESC = "delta_description";
    public static final String BASELINE_AVG = "baseline_avg";
    public static final String BASELINE_CALLS = "baseline_calls";
    public static final String ACTIVE_CALLS = "active_calls";
    public static final String TRANSACTION_SERIES = "transaction_series";
    public static final List<String> FIELDS = Arrays.asList("link", "transaction", "invocations", "time_consumed", "avg_response", "baseline_avg", "baseline_calls", "active_calls", "slow_state", "delta_description", "error_rate", "errors", "timeRange");
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="A comma delimited array defining which fields to add for each returned row. If no value\nis specified, all fields are added. link: a link pointing to the most recent Timer event set for the current entry point / trasnaction\n that has exceeded its threshold\ntransaction: the name expressed as class.method of the current transaction\ninvocations :the number of calls into the selected transaction\navg_response: the avg response time in ms for the completion of the execution of the current transaction\nin in the selected time frame\nbaseline_avg: the avg response time during the baseline time range.\nbaseline_calls: the number of calls for the current transaction during the baseline time range.\nactive_calls: a value showing the change between the event rate in the selected timeframe and the baseline\ntime_consumed: the avg response time * number of calls into the current transaction\n in in the selected time frame\nslow_state: the state of the transaction, either:\n\t Critical this transaction is slow compared to its baseline\n\t Slowing this transaction is in the process of slowing down\n\t OK this transaction avg response is in accordance with ts baselineerror_description: a text description of the volume of errors of the type defined in the Settings dashboard a \"transaction failure types\".\nerror_rate_state: the diff in rate between the active and baseline window \nerror_rate_delta_state: an enum state comparing the rate between the active and baseline window \nwith regression delta settings to output: OK, WARN, CRITICAL\ndelta_description: a text description of the volume of errors of the type defined in the Settings dashboard a \"transaction failure types\".\nerror_rate: the ratio between calls into the current transaction (invocations) and the volume of errors\nof the type defined in the Settings dashboard a \"transaction failure types\".\nerrors: the volume of errors of the type defined in the Settings dashboard a \"transaction failure types\".\ntimeRangethe simple name of the event entry point class name\n", defaultValue="")
    public String fields;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="A Java String format to be used when formatting the result of a single stat function call. ", defaultValue="")
    public String singleStatFormat;
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"Critical", "Slowing", "OK"}, defaultValue="Critical", description="A | delimited array of performance states, that a target transaction must meet in order to be returned\nby this function. Possible values are:Critical: The transaction has slown down\nSlowing: The transaction is in the process of slowning down\nOK: The tranaction performance is OK\n")
    public String performanceStates;

    public String getRenderMode() {
        if (this.renderMode == null || this.renderMode.isEmpty()) {
            return RENDER_SINGLE_STAT;
        }
        return this.renderMode;
    }

    public static Collection<PerformanceState> getStates(String performanceStates) {
        ArrayList<PerformanceState> result = new ArrayList<PerformanceState>();
        if (performanceStates != null) {
            String[] parts;
            for (String part : parts = performanceStates.split(GRAFANA_SEPERATOR)) {
                PerformanceState state = PerformanceState.valueOf(part);
                if (state == null) {
                    throw new IllegalStateException("Unsupported state " + part + " in " + performanceStates);
                }
                result.add(state);
            }
        } else {
            for (PerformanceState state : PerformanceState.values()) {
                result.add(state);
            }
        }
        return result;
    }
}

