/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.TransactionsVolumeInput;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;

@Function(name="transactionsRate", type=Function.FunctionType.Variable, description="A function used to return a single stat depicting the rate between calls into a target set of events entry points\nand the event volume. This could be used to show the ratio between calls into events entry points (i.e. transaction throughput)\nand a specific type of errors taking place within them (e.g transaction failures).", example="transactionsRate({\"type\":\"sum\",\"volumeType\":\"invocations\",\"view\":\"$view\",\n\"timeFilter\":\"$timeFilter\",\"environments\":\"$environments\", \"applications\":\"$applications\",\n\"deployments\":\"$deployments\",\"servers\":\"$servers\",\"types\":\"$transactionFailureTypes\",\n\"transactions\":\"$transactions\", \"filter\":\"events\",\"searchText\":\"$searchText\", \n\"transactionSearchText\":\"$searchText\",\"pointsWanted\":\"$transactionPointsWanted\"})", image="https://drive.google.com/file/d/1__-49ejQq0TAiRZ2l7sJC16nZRzA7kQZ/view?usp=sharing", isInternal=false)
public class TransactionsRateInput
extends TransactionsVolumeInput {
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"hits", "invocations", "all"}, defaultValue="all", description="the event volume type which serves as the denominator between throughput and volume returned \n by this function:\nhits: aggregate volume for all event that had hit volume\ninvocations: aggregate the ratio between even volume and the calls into events locations\nall:  aggregate volume for all events with either hits or invocations available\n")
    public ValidationUtil.VolumeType eventVolumeType;
    public static final String TRANSACTION_FILTER_EVENTS = "events";
    public static final String TRANSACTION_FILTER_TIMERS = "timers";
    @Param(type=Param.ParamType.Enum, advanced=false, literals={"events", "timers"}, defaultValue="events", description="The type of events whose volume is use to include in the denominator:\nevents: include only events of type Timer. This can be used to produce the ration between\nthroughput (i.e. calls into event entry points) and the number s of times timers\nset within them have exceeded their target thresholds\ntimers :include only events of type Timer. This can be used to produce the ration between\n throughput (i.e. calls into event entry points) and the number s of times timers\nset within them have exceeded their target thresholds\n")
    public String filter;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description="whether to limit the rate to 100. The rate could be greater in case a logged error for example\nhappens more than once per transaction as in the case of a retry loop.", defaultValue="false")
    public boolean allowExcceed100;
}

