/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.GraphInput;
import com.takipi.integrations.functions.annotations.Function;
import com.takipi.integrations.functions.annotations.Param;
import java.util.Collection;

@Function(name="typesGraph", type=Function.FunctionType.Graph, description="A function returning time series data of events matching a target filter, broken down by event type.", example="typesGraph({\"graphType\":\"view\",\"volumeType\":\"all\",\"view\":\"$view\",\"timeFilter\":\"$timeFilter\",\n\"environments\":\"$environments\", \"applications\":\"$applications\", \"servers\":\"$servers\",\n\"deployments\":\"$deployments\",\"pointsWanted\":\"$pointsWanted\",\"types\":\"$type\",\n\"seriesName\":\"Times\", \"transactions\":\"$transactions\", \"searchText\":\"$search\",\n\"defaultTypes\":\"Logged Error|Uncaught Exception|HTTP Error\"})", image="", isInternal=false)
public class TypesGraphInput
extends GraphInput {
    @Param(type=Param.ParamType.String, advanced=false, literals={}, description="A | delimited array of event types for which time series volume data would be split.", defaultValue="")
    public String defaultTypes;

    public Collection<String> getDefaultTypes() {
        if (!TypesGraphInput.hasFilter(this.defaultTypes)) {
            return null;
        }
        return TypesGraphInput.getServiceFilters(this.defaultTypes, null, true);
    }
}

