/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.FunctionInput;
import com.takipi.common.util.ArrayUtil;
import com.takipi.integrations.functions.annotations.Param;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class VariableInput
extends FunctionInput {
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description="Control whether values of this variable are sorted alphabetically or logically", defaultValue="false")
    public boolean sorted;
    @Param(type=Param.ParamType.Boolean, advanced=false, literals={}, description="Controls whether values are added as separate items, or as one comma delimited value", defaultValue="false")
    public boolean commaDelimited;

    public static boolean hasFilter(String value) {
        return value != null && value.length() != 0 && !VAR_ALL.contains(value);
    }

    public static Collection<String> getServiceFilters(String value, String serviceId, boolean matchCase) {
        if (!VariableInput.hasFilter(value)) {
            return Collections.emptyList();
        }
        String target = value.startsWith("(") && value.endsWith(")") ? value.substring(1, value.length() - 1) : value;
        String[] parts = ArrayUtil.safeSplitArray(target, GRAFANA_SEPERATOR, false);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.length() == 0) continue;
            if (!matchCase) {
                part = part.toLowerCase();
            }
            String[] subParts = part.split(": ");
            if (serviceId != null && subParts.length > 1) {
                if (!serviceId.equals(subParts[1])) continue;
                result.add(subParts[0]);
                continue;
            }
            result.add(part);
        }
        return new ArrayList<String>(result);
    }
}

