/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.input;

import com.takipi.api.client.functions.input.EnvironmentsFilterInput;
import com.takipi.common.util.ObjectUtil;
import com.takipi.integrations.functions.annotations.Param;
import java.util.Collection;
import java.util.Collections;

public abstract class ViewInput
extends EnvironmentsFilterInput {
    @Param(type=Param.ParamType.String, advanced=false, literals={}, defaultValue="All Events", description="The name of the view to query for events. For example: \"All Events\".")
    public String view;
    @Param(type=Param.ParamType.String, advanced=false, literals={}, defaultValue="", description="A comma delimited list of entry points in either simple class name or simple class name + method format.\nFor example: \"myServlet,\"myOtherServlet.doGet\" will only choose events whose entry point\nis \"myServlet\" (regardless of a method name) or whose entry point class is \"myOtherServlet\" and\nmethod name is \"doGet\".")
    public String transactions;
    @Param(type=Param.ParamType.String, advanced=true, literals={}, defaultValue="", description="A time filter denoting the time range in which this query operates. The format os the time filter\nshould match the Grafana time range format: http://docs.grafana.org/reference/timerange/")
    public String timeFilter;
    @Param(type=Param.ParamType.Boolean, advanced=true, literals={}, defaultValue="false", description="A value indicating whether this timeFilter is passed from within a template variable")
    public boolean varTimeFilter;
    public static final String NO_DATA_SERIES = "no_data_series";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String TIME_RANGE = "timeRange";

    public boolean hasTransactions() {
        return ViewInput.hasFilter(this.transactions);
    }

    public Collection<String> getTransactions(String serviceId) {
        if (!this.hasTransactions()) {
            return Collections.emptyList();
        }
        Collection<String> result = ViewInput.getServiceFilters(this.transactions, serviceId, true);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ViewInput)) {
            return false;
        }
        ViewInput other = (ViewInput)((Object)obj);
        return ObjectUtil.equal((Object)this.view, (Object)other.view) && ObjectUtil.equal((Object)this.transactions, (Object)other.transactions) && ObjectUtil.equal((Object)this.timeFilter, (Object)other.timeFilter);
    }

    @Override
    public int hashCode() {
        if (this.view != null) {
            return super.hashCode() ^ this.view.hashCode();
        }
        return super.hashCode();
    }
}

