/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.output;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.functions.input.BaseEventVolumeInput;
import com.takipi.api.client.functions.input.ReliabilityReportInput;
import com.takipi.api.client.functions.output.EventRow;
import com.takipi.api.client.functions.output.QueryResult;
import com.takipi.api.client.functions.output.RegressionRow;
import com.takipi.api.client.functions.output.ReliabilityReportRow;
import com.takipi.api.client.functions.output.Series;
import com.takipi.api.client.functions.output.SeriesHeader;
import com.takipi.api.client.functions.output.SeriesRow;
import com.takipi.api.client.functions.output.TransactionRow;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.url.UrlClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReliabilityReport {
    public Map<ReliabilityReportRow.Header, ReliabilityReportItem> items = new HashMap<ReliabilityReportRow.Header, ReliabilityReportItem>();

    protected ReliabilityReport() {
    }

    public static ReliabilityReport execute(ApiClient apiClient, ReliabilityReportInput input) {
        UrlClient.Response response = apiClient.get((ApiGetRequest)input);
        if (response.isBadResponse()) {
            return null;
        }
        ReliabilityReport result = new ReliabilityReport();
        for (Series<SeriesRow> series : ((QueryResult)response.data).getSeries()) {
            if (!series.type.equals("reliability_report") || series.type.equals("no_data_series")) continue;
            for (SeriesRow row : series) {
                ReliabilityReportRow rrRow = (ReliabilityReportRow)row;
                ReliabilityReportItem rrItem = new ReliabilityReportItem(rrRow);
                ReliabilityReportRow.Header rrHeader = new ReliabilityReportRow.Header(rrRow.serviceId, rrRow.key);
                result.items.put(rrHeader, rrItem);
            }
        }
        for (Series<SeriesRow> series : ((QueryResult)response.data).getSeries()) {
            ReliabilityReportRow.Header rrHeader;
            ReliabilityReportItem rrItem;
            SeriesHeader header = series.getHeader();
            if (!(header instanceof ReliabilityReportRow.Header) || (rrItem = result.items.get(rrHeader = (ReliabilityReportRow.Header)header)) == null) continue;
            switch (series.type) {
                case "relability_report_regressions": {
                    rrItem.regressions = series;
                    break;
                }
                case "reliability_report_failures": {
                    rrItem.failures = series;
                    break;
                }
                case "reliability_report_errors": {
                    rrItem.errors = series;
                    break;
                }
                case "reliability_reporty_slowdown": {
                    rrItem.transactions = series;
                }
            }
        }
        return result;
    }

    public static class ReliabilityReportItem {
        public ReliabilityReportRow row;
        public Series<RegressionRow> regressions;
        public Series<EventRow> errors;
        public Series<EventRow> failures;
        public Series<TransactionRow> transactions;

        protected ReliabilityReportItem(ReliabilityReportRow row) {
            this.row = row;
        }

        public Collection<RegressionRow> getNewErrors(boolean includeNonSev, boolean includeSev) {
            if (this.regressions == null) {
                return Collections.emptyList();
            }
            ArrayList<RegressionRow> result = new ArrayList<RegressionRow>(this.regressions.size());
            for (RegressionRow row : this.regressions) {
                if (includeNonSev && row.regression_type.equals("NewIssues")) {
                    result.add(row);
                }
                if (!includeSev || !row.regression_type.equals("SevereNewIssues")) continue;
                result.add(row);
            }
            return result;
        }

        public Collection<RegressionRow> geIncErrors(boolean includeNonSev, boolean includeSev) {
            if (this.regressions == null) {
                return Collections.emptyList();
            }
            ArrayList<RegressionRow> result = new ArrayList<RegressionRow>(this.regressions.size());
            for (RegressionRow row : this.regressions) {
                if (includeNonSev && row.regression_type.equals("Regressions")) {
                    result.add(row);
                }
                if (!includeSev || !row.regression_type.equals("SevereRegressions")) continue;
                result.add(row);
            }
            return result;
        }

        public Collection<TransactionRow> getSlowdowns(boolean includeNonSev, boolean includeSev) {
            if (this.transactions == null) {
                return Collections.emptyList();
            }
            ArrayList<TransactionRow> result = new ArrayList<TransactionRow>(this.transactions.size());
            for (TransactionRow row : this.transactions) {
                if (includeNonSev && row.slow_state == BaseEventVolumeInput.SLOWING_ORDINAL) {
                    result.add(row);
                }
                if (!includeSev || row.slow_state != BaseEventVolumeInput.CRITICAL_ORDINAL) continue;
                result.add(row);
            }
            return result;
        }
    }
}

