/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.output;

import com.google.gson.Gson;
import com.takipi.api.client.functions.output.EventRow;
import com.takipi.api.client.functions.output.GraphRow;
import com.takipi.api.client.functions.output.RegressionRow;
import com.takipi.api.client.functions.output.ReliabilityReportRow;
import com.takipi.api.client.functions.output.SeriesHeader;
import com.takipi.api.client.functions.output.SeriesReader;
import com.takipi.api.client.functions.output.SeriesRow;
import com.takipi.api.client.functions.output.TransactionRow;
import com.takipi.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Series<T extends SeriesRow>
implements Iterable<T> {
    public static final String SUM_COLUMN = "sum";
    public static final String TIME_COLUMN = "time";
    private static final Gson gson = new Gson();
    private static Map<String, SeriesReader<?>> seriesReaders = new HashMap();
    private SeriesReader<T> reader;
    public String name;
    public String type;
    public String header;
    public List<String> tags;
    public List<String> columns;
    public List<List<Object>> values;

    public Object getValue(String column, int index) {
        return this.getValue(column, index, false);
    }

    public Object getValue(int colIndex, int index) {
        if (this.values == null) {
            throw new IllegalStateException("colIndex null");
        }
        if (index < 0 || index > this.values.size()) {
            throw new IllegalArgumentException("Bad row index " + String.valueOf(index) + " for " + this.values.size() + " rows");
        }
        List<Object> row = this.values.get(index);
        if (colIndex > row.size()) {
            throw new IllegalArgumentException("Bad column index " + String.valueOf(colIndex) + " for row " + index + " with " + row.size());
        }
        Object result = row.get(colIndex);
        return result;
    }

    private int getColumnIndex(String column, boolean mustExist) {
        if (this.columns == null) {
            throw new IllegalStateException("columns null");
        }
        int result = this.columns.indexOf(column);
        if (result == -1) {
            if (!mustExist) {
                return -1;
            }
            throw new IllegalArgumentException(column + " not found in " + String.join((CharSequence)",", this.columns));
        }
        return result;
    }

    public Object getValue(String column, int index, boolean mustExist) {
        int colIndex = this.getColumnIndex(column, mustExist);
        if (colIndex == -1) {
            return null;
        }
        return this.getValue(colIndex, index);
    }

    public boolean isSingleStat() {
        if (this.values == null) {
            return false;
        }
        if (this.columns == null) {
            return false;
        }
        if (this.values.size() != 1) {
            return false;
        }
        if (!this.columns.contains(SUM_COLUMN)) {
            return false;
        }
        return this.columns.contains(TIME_COLUMN);
    }

    public Object getSingleStat() {
        if (!this.isSingleStat()) {
            throw new IllegalStateException("Not a single stat series");
        }
        return this.getValue(SUM_COLUMN, 0);
    }

    public long getLong(String column, int index) {
        Object value = this.getValue(column, index);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Long.valueOf(value.toString());
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public int getInt(String column, int index) {
        return (int)this.getLong(column, index);
    }

    public String getString(String column, int index) {
        Object value = this.getValue(column, index);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected double parseDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Long)value).longValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return Long.valueOf(value.toString()).longValue();
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public double getDouble(String column, int index) {
        Object value = this.getValue(column, index);
        return this.parseDouble(value);
    }

    public boolean getBoolean(String column, int index) {
        Object value = this.getValue(column, index);
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            try {
                return Boolean.valueOf(value.toString());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void sort(String columnName, boolean ascending, boolean numerically) {
        if (numerically) {
            this.sortNumerically(columnName, ascending);
        } else {
            this.sortComparabales(columnName, ascending);
        }
    }

    private void sortNumerically(String columnName, final boolean ascending) {
        if (CollectionUtil.safeIsEmpty(this.values)) {
            return;
        }
        final int colIndex = this.getColumnIndex(columnName, true);
        this.values.sort(new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                double c2;
                double c1;
                Object v1 = o1.get(colIndex);
                Object v2 = o2.get(colIndex);
                if (ascending) {
                    c1 = Series.this.parseDouble(v1);
                    c2 = Series.this.parseDouble(v2);
                } else {
                    c1 = Series.this.parseDouble(v2);
                    c2 = Series.this.parseDouble(v1);
                }
                return Double.compare(c1, c2);
            }
        });
    }

    private void sortComparabales(String columnName, final boolean ascending) {
        if (CollectionUtil.safeIsEmpty(this.values)) {
            return;
        }
        final int colIndex = this.getColumnIndex(columnName, true);
        this.values.sort(new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                Object c2;
                Comparable c1;
                Object v1 = o1.get(colIndex);
                Object v2 = o2.get(colIndex);
                if (ascending) {
                    c1 = v1 instanceof Comparable ? (Comparable)v1 : null;
                    c2 = v2;
                } else {
                    c1 = v2 instanceof Comparable ? (Comparable)v2 : null;
                    c2 = v1;
                }
                if (c1 == null) {
                    return 0;
                }
                return c1.compareTo(c2);
            }
        });
    }

    public List<SeriesRow> readRows() {
        int size = this.size();
        ArrayList<SeriesRow> result = new ArrayList<SeriesRow>(size);
        if (size == 0) {
            return result;
        }
        for (SeriesRow row : this) {
            result.add(row);
        }
        return result;
    }

    public T readRow(int index) {
        if (this.type == null) {
            return null;
        }
        SeriesReader<T> reader = this.getReader();
        if (reader == null) {
            return null;
        }
        return reader.read(this, index);
    }

    private SeriesReader<T> getReader() {
        if (this.reader != null) {
            return this.reader;
        }
        this.reader = seriesReaders.get(this.type);
        return this.reader;
    }

    public SeriesHeader getHeader() {
        if (this.type == null) {
            return null;
        }
        if (this.header == null) {
            return null;
        }
        SeriesReader<T> reader = this.getReader();
        if (reader == null) {
            return null;
        }
        Class<SeriesHeader> headerClass = reader.headerType();
        if (headerClass == null) {
            return null;
        }
        return (SeriesHeader)gson.fromJson(this.header, headerClass);
    }

    public Class<?> getRowType() {
        if (this.type == null) {
            return null;
        }
        SeriesReader<T> reader = this.getReader();
        if (reader == null) {
            return null;
        }
        return reader.rowType();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < Series.this.values.size();
            }

            @Override
            public T next() {
                return Series.this.readRow(this.index++);
            }
        };
    }

    public int size() {
        if (CollectionUtil.safeIsEmpty(this.values)) {
            return 0;
        }
        return this.values.size();
    }

    static {
        seriesReaders.put("events_series", new EventRow.Reader());
        seriesReaders.put("graph", new GraphRow.Reader());
        seriesReaders.put("transaction_series", new TransactionRow.Reader());
        seriesReaders.put("regressions_series", new RegressionRow.Reader());
        seriesReaders.put("reliability_report", new ReliabilityReportRow.Reader());
        seriesReaders.put("relability_report_regressions", new ReliabilityReportRow.RegressionReader());
        seriesReaders.put("reliability_report_errors", new ReliabilityReportRow.EventVolumeReader());
        seriesReaders.put("reliability_report_failures", new ReliabilityReportRow.EventVolumeReader());
        seriesReaders.put("reliability_reporty_slowdown", new ReliabilityReportRow.SlowdownReader());
    }
}

