/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.sample;

import com.takipi.api.client.data.event.Location;
import com.takipi.api.client.functions.input.BaseEventVolumeInput;
import com.takipi.api.client.functions.input.GraphInput;
import com.takipi.api.client.functions.input.ReliabilityReportInput;
import com.takipi.api.client.functions.input.VolumeInput;
import com.takipi.api.client.functions.output.BaseEventRow;
import com.takipi.api.client.functions.output.EventRow;
import com.takipi.api.client.functions.output.GraphRow;
import com.takipi.api.client.functions.output.QueryResult;
import com.takipi.api.client.functions.output.RegressionRow;
import com.takipi.api.client.functions.output.ReliabilityReport;
import com.takipi.api.client.functions.output.ReliabilityReportRow;
import com.takipi.api.client.functions.output.Series;
import com.takipi.api.client.functions.output.SeriesRow;
import com.takipi.api.client.functions.output.TransactionRow;
import com.takipi.api.client.functions.sample.StandaloneQueryApiClient;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.TimeUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OverOpsFunctionsSample {
    private static final String TAB = "\t";
    private static final String TAB2 = "\t\t";

    public static void main(String[] args) {
        String apiServer = args[0];
        String apiToken = args[1];
        String appServer = args[2];
        String serviceId = args[3];
        StandaloneQueryApiClient apiClient = StandaloneQueryApiClient.newBuilder().setUsername(apiServer).setHostname(appServer).setPassword(apiToken).build();
        OverOpsFunctionsSample.runReliabilityReport(apiClient, serviceId);
        OverOpsFunctionsSample.runGraph(apiClient, serviceId);
        OverOpsFunctionsSample.runVolume(apiClient, serviceId);
    }

    public static void runVolume(StandaloneQueryApiClient apiClient, String serviceId) {
        VolumeInput input = new VolumeInput();
        input.environments = serviceId;
        input.timeFilter = TimeUtil.getLastWindowTimeFilter(TimeUnit.DAYS.toMillis(1L));
        input.volumeType = ValidationUtil.VolumeType.all;
        input.type = "sum";
        UrlClient.Response response = apiClient.get(input);
        if (response.isBadResponse()) {
            throw new IllegalStateException("volume failed");
        }
        for (Series<SeriesRow> series : ((QueryResult)response.data).getSeries()) {
            System.out.println("volume = " + series.getSingleStat());
        }
    }

    public static void runGraph(StandaloneQueryApiClient apiClient, String serviceId) {
        GraphInput input = new GraphInput();
        input.timeFilter = TimeUtil.getLastWindowTimeFilter(TimeUnit.DAYS.toMillis(1L));
        input.volumeType = ValidationUtil.VolumeType.all;
        input.environments = serviceId;
        UrlClient.Response response = apiClient.get(input);
        if (response.isBadResponse()) {
            throw new IllegalStateException("graph failed");
        }
        for (Series<SeriesRow> series : ((QueryResult)response.data).getSeries()) {
            System.out.println(series.name);
            for (int i = 0; i < series.values.size(); ++i) {
                GraphRow row = (GraphRow)series.readRow(i);
                System.out.print(row.time + " " + row.value + ",");
            }
        }
    }

    public static void runReliabilityReport(StandaloneQueryApiClient apiClient, String serviceId) {
        ReliabilityReportInput input = new ReliabilityReportInput();
        input.environments = serviceId;
        input.timeFilter = TimeUtil.getLastWindowTimeFilter(TimeUnit.DAYS.toMillis(1L));
        input.mode = "Default";
        input.limit = 5;
        input.outputDrillDownSeries = true;
        input.requestStackframes = true;
        ReliabilityReport reliabilityReport = ReliabilityReport.execute(apiClient, input);
        if (reliabilityReport == null) {
            throw new IllegalStateException("Reliability report failed");
        }
        for (Map.Entry<ReliabilityReportRow.Header, ReliabilityReport.ReliabilityReportItem> entry : reliabilityReport.items.entrySet()) {
            ReliabilityReportRow.Header rrHeader = entry.getKey();
            ReliabilityReport.ReliabilityReportItem rrItem = entry.getValue();
            OverOpsFunctionsSample.printReportItemScore(rrHeader, rrItem);
            OverOpsFunctionsSample.printReportNewErrors(rrItem);
            OverOpsFunctionsSample.printReportIncErrors(rrItem);
            OverOpsFunctionsSample.printReportItemFailures(rrItem, 5);
            OverOpsFunctionsSample.printReportItemTopEventsByVolume(rrItem, 5);
            OverOpsFunctionsSample.printReportItemSlowdowns(rrItem);
        }
    }

    private static void printReportItemScore(ReliabilityReportRow.Header rrHeader, ReliabilityReport.ReliabilityReportItem rrItem) {
        System.out.println(rrHeader.serviceId + ", app = " + rrHeader.key + " = " + rrItem.row.score);
    }

    private static String printLocation(BaseEventRow row) {
        if (CollectionUtil.safeIsEmpty(row.stack_frames)) {
            return "";
        }
        Location loc = row.stack_frames.get(0);
        return "in " + loc.class_name + "." + loc.method_name;
    }

    private static void printReportNewErrors(ReliabilityReport.ReliabilityReportItem rrItem) {
        System.out.println("\tNew Errors: ");
        for (RegressionRow row : rrItem.getNewErrors(true, true)) {
            System.out.println(TAB2 + row.summary + "= " + row.regression_type + " " + OverOpsFunctionsSample.printLocation(row));
        }
    }

    private static void printReportIncErrors(ReliabilityReport.ReliabilityReportItem rrItem) {
        System.out.println("\tInc Errors: ");
        for (RegressionRow row : rrItem.geIncErrors(true, true)) {
            System.out.println(TAB2 + row.summary + "= " + row.regression_type + " " + OverOpsFunctionsSample.printLocation(row));
        }
    }

    private static void printReportItemFailures(ReliabilityReport.ReliabilityReportItem rrItem, int top) {
        System.out.println("\tTop rank failures: ");
        int size = Math.min(rrItem.failures.size(), top);
        for (int i = 0; i < size; ++i) {
            EventRow evRow = rrItem.failures.readRow(i);
            System.out.println(TAB2 + evRow.summary);
        }
    }

    private static void printReportItemTopEventsByVolume(ReliabilityReport.ReliabilityReportItem rrItem, int top) {
        System.out.println("\tTop volume errors: ");
        rrItem.errors.sort("stats.hits", false, true);
        int size = Math.min(rrItem.errors.size(), top);
        for (int i = 0; i < size; ++i) {
            EventRow row = rrItem.errors.readRow(i);
            System.out.println(TAB2 + row.summary + " volume  = " + row.hits);
        }
    }

    private static void printReportItemSlowdowns(ReliabilityReport.ReliabilityReportItem rrItem) {
        System.out.println("\tSlowdowns: ");
        Collection<TransactionRow> rows = rrItem.getSlowdowns(true, true);
        for (TransactionRow row : rows) {
            String desc = BaseEventVolumeInput.TRANSACTION_STATES.get(row.slow_state);
            System.out.println(TAB2 + row.transaction + " slowdown state = " + desc);
        }
    }
}

