/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.functions.sample;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.BaseApiClient;
import com.takipi.api.client.observe.Observer;
import com.takipi.api.core.request.intf.ApiRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.Pair;
import com.takipi.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StandaloneQueryApiClient
extends BaseApiClient
implements ApiClient {
    private static final String OO_AS_INFLUX_PATH = "/oo-as-influx";

    StandaloneQueryApiClient(String hostname, Pair<String, String> auth, int connectTimeout, int readTimeout, UrlClient.LogLevel defaultLogLevel, Map<Integer, UrlClient.LogLevel> responseLogLevels, Collection<Observer> observers) {
        super(hostname, auth, connectTimeout, readTimeout, defaultLogLevel, responseLogLevels, observers);
    }

    protected String baseApiPath() {
        return this.getHostname();
    }

    protected String buildTargetUrl(ApiRequest apiRequest) throws UnsupportedEncodingException {
        return super.buildTargetUrl(apiRequest).replace(OO_AS_INFLUX_PATH, "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StandaloneQueryApiClient)) {
            return false;
        }
        return super.equals(obj);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getApiVersion() {
        return 0;
    }

    public static class Builder
    extends BaseApiClient.Builder {
        Builder() {
        }

        public Builder setHostname(String hostname) {
            super.setHostname(hostname);
            return this;
        }

        public Builder setUsername(String username) {
            super.setUsername(username);
            return this;
        }

        public Builder setPassword(String password) {
            super.setPassword(password);
            return this;
        }

        public Builder setApiKey(String apiKey) {
            super.setApiKey(apiKey);
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            super.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            super.setReadTimeout(readTimeout);
            return this;
        }

        public Builder setDefaultLogLevel(UrlClient.LogLevel defaultLogLevel) {
            super.setDefaultLogLevel(defaultLogLevel);
            return this;
        }

        public Builder setResponseLogLevel(int responseCode, UrlClient.LogLevel logLevel) {
            super.setResponseLogLevel(responseCode, logLevel);
            return this;
        }

        public Builder addObserver(Observer observer) {
            super.addObserver(observer);
            return this;
        }

        public StandaloneQueryApiClient build() {
            if (StringUtil.isNullOrEmpty((String)this.hostname)) {
                throw new IllegalArgumentException("Missing hostname");
            }
            return new StandaloneQueryApiClient(this.hostname, (Pair<String, String>)this.getAuth(), this.connectTimeout, this.readTimeout, this.defaultLogLevel, new HashMap<Integer, UrlClient.LogLevel>(this.responseLogLevels), this.observers);
        }
    }
}

