/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.alert;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.alert.Anomaly;
import com.takipi.api.client.request.alert.AnomalyAlertRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import java.util.Collection;
import org.joda.time.DateTime;

public class AlertUtil {
    public static void reportAnomaly(ApiClient apiClient, String serviceId, String viewId, Collection<EventResult> events, DateTime from, DateTime to, String desc) {
        Anomaly anomaly = Anomaly.create();
        anomaly.addAnomalyPeriod(viewId, from.getMillis(), to.getMillis());
        for (EventResult event : events) {
            if (event.stats == null || event.stats.hits <= 0L) continue;
            anomaly.addContributor(Integer.parseInt(event.id), event.stats.hits);
        }
        AnomalyAlertRequest anomalyAlertRequest = AnomalyAlertRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).setFrom(from.toString()).setTo(to.toString()).setDesc(desc).setAnomaly(anomaly).build();
        UrlClient.Response anomalyAlertResponse = apiClient.post((ApiPostRequest)anomalyAlertRequest);
        if (anomalyAlertResponse.isBadResponse()) {
            throw new IllegalStateException("Failed alerting on anomaly for view - " + viewId);
        }
    }
}

