/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.category;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.category.Category;
import com.takipi.api.client.request.category.CategoriesRequest;
import com.takipi.api.client.request.category.CategoryAddViewRequest;
import com.takipi.api.client.request.category.CreateCategoryRequest;
import com.takipi.api.client.result.category.CategoriesResult;
import com.takipi.api.client.result.category.CreateCategoryResult;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.StringUtil;
import java.util.Collection;

public class CategoryUtil {
    public static Category getServiceCategoryByName(ApiClient apiClient, String serviceId, String categoryName) {
        CategoriesRequest categoriesRequest = CategoriesRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response createCategoryResponse = apiClient.get((ApiGetRequest)categoriesRequest);
        if (createCategoryResponse.isOK() && ((CategoriesResult)createCategoryResponse.data).categories != null) {
            for (Category category : ((CategoriesResult)createCategoryResponse.data).categories) {
                if (!categoryName.equals(category.name)) continue;
                return category;
            }
        }
        return null;
    }

    public static String createCategory(String categoryName, String serviceId, ApiClient apiClient) {
        return CategoryUtil.createCategory(categoryName, serviceId, apiClient, true);
    }

    public static String createCategory(String categoryName, String serviceId, ApiClient apiClient, boolean shared) {
        CreateCategoryRequest createCategoryRequest = CreateCategoryRequest.newBuilder().setServiceId(serviceId).setName(categoryName).setShared(shared).build();
        UrlClient.Response createCategoryResponse = apiClient.post((ApiPostRequest)createCategoryRequest);
        if (createCategoryResponse.isOK()) {
            CreateCategoryResult createCategoryResult = (CreateCategoryResult)createCategoryResponse.data;
            if (createCategoryResult == null || StringUtil.isNullOrEmpty((String)createCategoryResult.category_id)) {
                throw new IllegalStateException("Failed creating category - " + categoryName);
            }
            return createCategoryResult.category_id;
        }
        if (createCategoryResponse.responseCode != 409) {
            throw new IllegalStateException("Failed creating category - " + categoryName);
        }
        CategoriesRequest getCategoriesRequest = CategoriesRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response getCategoriesResponse = apiClient.get((ApiGetRequest)getCategoriesRequest);
        if (getCategoriesResponse.isBadResponse() || getCategoriesResponse.data == null || CollectionUtil.safeIsEmpty((Collection)((CategoriesResult)getCategoriesResponse.data).categories)) {
            throw new IllegalStateException("Failed getting category - " + categoryName);
        }
        for (Category category : ((CategoriesResult)getCategoriesResponse.data).categories) {
            if (!categoryName.equalsIgnoreCase(category.name) || StringUtil.isNullOrEmpty((String)category.id)) continue;
            return category.id;
        }
        throw new IllegalStateException("Failed getting category - " + categoryName);
    }

    public static void addViewToCategory(String categoryId, String viewId, String serviceId, ApiClient apiClient) {
        CategoryAddViewRequest categoryAddViewRequest = CategoryAddViewRequest.newBuilder().setServiceId(serviceId).setCategoryId(categoryId).setViewId(viewId).build();
        UrlClient.Response createResponse = apiClient.post((ApiPostRequest)categoryAddViewRequest);
        if (createResponse.isBadResponse()) {
            throw new IllegalStateException("Failed adding view " + viewId + " to category " + categoryId);
        }
    }
}

