/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.cicd;

import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.cicd.OOReportEvent;
import com.takipi.api.client.util.cicd.QualityGateReport;
import com.takipi.api.client.util.event.EventUtil;
import com.takipi.api.client.util.regression.RateRegression;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionUtil;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.Pair;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class ProcessQualityGates {
    private static QualityGateReport qualityReport;

    public static QualityGateReport processCICDInputs(ApiClient apiClient, RegressionInput input, boolean newEvents, boolean resurfacedEvents, String regexFilter, int topIssuesVolume, boolean countGate, PrintStream printStream, boolean verbose) {
        qualityReport = new QualityGateReport();
        Pair<DateTime, DateTime> deploymentsActiveWindow = null;
        deploymentsActiveWindow = input.deployments == null || input.deployments.size() == 0 ? RegressionUtil.getDeploymentsActiveWindow(apiClient, input.serviceId) : RegressionUtil.getDeploymentsActiveWindow(apiClient, input.serviceId, input.deployments);
        if (deploymentsActiveWindow == null || deploymentsActiveWindow.getFirst() == null) {
            if (input.deployments == null || input.deployments.size() == 0) {
                throw new IllegalStateException("Unable to determine active window for report.");
            }
            throw new IllegalStateException("Deployments " + Arrays.toString(input.deployments.toArray()) + " not found. Please ensure your collector and CI/CD configuration are pointing to the same environment.");
        }
        DateTime deploymentStart = (DateTime)deploymentsActiveWindow.getFirst();
        Collection<EventResult> events = ProcessQualityGates.getEvents(apiClient, input, deploymentStart, printStream);
        if (events != null && events.size() > 0) {
            events = ProcessQualityGates.filterEvents(events, regexFilter);
            if (countGate) {
                events = RateRegression.getSortedNewEvents(events);
                qualityReport.setTopErrors(ProcessQualityGates.getTopXEvents(apiClient, input, events, topIssuesVolume, deploymentStart));
            }
            if (newEvents) {
                qualityReport.setNewErrors(ProcessQualityGates.getNewErrors(apiClient, input, events, deploymentStart));
            }
            if (resurfacedEvents) {
                qualityReport.setResurfacedErrors(ProcessQualityGates.getResurfacedErrors(apiClient, input, events, deploymentStart));
            }
            if (input.criticalExceptionTypes != null) {
                qualityReport.setCriticalErrors(ProcessQualityGates.getCriticalErrors(apiClient, input, events, deploymentStart));
            }
        }
        return qualityReport;
    }

    private static Collection<EventResult> getEvents(ApiClient apiClient, RegressionInput input, DateTime deploymentStart, PrintStream printStream) {
        Collection<EventResult> events = RegressionUtil.getActiveEventVolume(apiClient, input, deploymentStart, printStream);
        if (!CollectionUtil.safeIsEmpty(events)) {
            return events;
        }
        events = RegressionUtil.getActiveEventVolume(apiClient, input, deploymentStart, printStream, true);
        if (CollectionUtil.safeIsEmpty(events) || CollectionUtil.safeIsEmpty(input.applictations)) {
            return events;
        }
        return ProcessQualityGates.filterByLabel(events, (List)input.applictations);
    }

    private static List<EventResult> filterByLabel(Collection<EventResult> inputEvents, List<String> list) {
        String appName = list.get(0) + ".app";
        ArrayList<EventResult> result = new ArrayList<EventResult>();
        for (EventResult eventResult : inputEvents) {
            if (eventResult.labels == null || !eventResult.labels.contains(appName)) continue;
            result.add(eventResult);
        }
        if (CollectionUtil.safeIsEmpty(result)) {
            throw new IllegalStateException("Application(s) " + Arrays.toString(list.toArray()) + " not found. Please ensure Application names(s) provided are correct.");
        }
        return result;
    }

    private static List<OOReportEvent> getTopXEvents(ApiClient apiClient, RegressionInput input, Collection<EventResult> events, int topIssuesVolume, DateTime deploymentStart) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            String arcLink = ProcessQualityGates.getArcLink(apiClient, event.id, input, deploymentStart);
            OOReportEvent newEvent = new OOReportEvent(event, null, arcLink);
            newEvent.setApplications(ProcessQualityGates.getAppNames(input, event));
            result.add(newEvent);
            if (result.size() != topIssuesVolume) continue;
            break;
        }
        return result;
    }

    private static List<OOReportEvent> getCriticalErrors(ApiClient apiClient, RegressionInput input, Collection<EventResult> events, DateTime deploymentStart) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            if (!input.criticalExceptionTypes.contains(event.name)) continue;
            String arcLink = ProcessQualityGates.getArcLink(apiClient, event.id, input, deploymentStart);
            OOReportEvent newEvent = new OOReportEvent(event, null, arcLink);
            newEvent.setApplications(ProcessQualityGates.getAppNames(input, event));
            result.add(newEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getResurfacedErrors(ApiClient apiClient, RegressionInput input, Collection<EventResult> events, DateTime deploymentStart) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            if (!event.labels.contains("Resurfaced")) continue;
            String arcLink = ProcessQualityGates.getArcLink(apiClient, event.id, input, deploymentStart);
            OOReportEvent newEvent = new OOReportEvent(event, null, arcLink);
            newEvent.setApplications(ProcessQualityGates.getAppNames(input, event));
            result.add(newEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getNewErrors(ApiClient apiClient, RegressionInput input, Collection<EventResult> events, DateTime deploymentStart) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            if (input.deployments != null && input.deployments.size() > 0 && !input.deployments.contains(event.introduced_by)) continue;
            String arcLink = ProcessQualityGates.getArcLink(apiClient, event.id, input, deploymentStart);
            OOReportEvent newEvent = new OOReportEvent(event, "New", arcLink);
            newEvent.setApplications(ProcessQualityGates.getAppNames(input, event));
            result.add(newEvent);
        }
        return result;
    }

    private static String getAppNames(RegressionInput input, EventResult event) {
        String appName = null;
        if (input.applictations != null && !input.applictations.isEmpty()) {
            List list = (List)input.applictations;
            appName = (String)list.get(0);
        } else {
            boolean firstEvent = true;
            List labelList = event.labels;
            for (String string : labelList) {
                if (!string.contains(".app")) continue;
                int endpointPoint = string.indexOf(".app");
                if (firstEvent) {
                    appName = string.substring(0, endpointPoint);
                    continue;
                }
                appName = appName + ", " + string.substring(0, endpointPoint);
            }
        }
        return appName;
    }

    public static String getArcLink(ApiClient apiClient, String eventId, RegressionInput input, DateTime activeWindowStart) {
        DateTime from = activeWindowStart.minusMinutes(input.baselineTimespan);
        String result = EventUtil.getEventRecentLinkDefault(apiClient, input.serviceId, eventId, from, DateTime.now(), input.applictations, input.servers, input.deployments, EventUtil.DEFAULT_PERIOD);
        return result;
    }

    private static Collection<EventResult> filterEvents(Collection<EventResult> events, String regexFilter) {
        if (regexFilter == null) {
            return events;
        }
        ArrayList<EventResult> returnEvents = new ArrayList<EventResult>();
        for (EventResult event : events) {
            if (!ProcessQualityGates.evaluateEvent(event, ProcessQualityGates.getPattern(regexFilter))) continue;
            returnEvents.add(event);
            qualityReport.addToTotalErrorCount(event.stats.hits);
            qualityReport.addToUniqueErrorCount(1);
        }
        return returnEvents;
    }

    private static boolean evaluateEvent(EventResult event, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        String json = new Gson().toJson((Object)event);
        boolean result = !pattern.matcher(json).find();
        return result;
    }

    private static Pattern getPattern(String regexFilter) {
        Pattern pattern = regexFilter != null && regexFilter.length() > 0 ? Pattern.compile(regexFilter) : null;
        return pattern;
    }
}

