/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.client;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.application.SummarizedApplication;
import com.takipi.api.client.data.deployment.SummarizedDeployment;
import com.takipi.api.client.data.server.SummarizedServer;
import com.takipi.api.client.data.service.SummarizedService;
import com.takipi.api.client.request.application.ApplicationsRequest;
import com.takipi.api.client.request.deployment.DeploymentsRequest;
import com.takipi.api.client.request.server.ServersRequest;
import com.takipi.api.client.request.service.ServicesRequest;
import com.takipi.api.client.result.application.ApplicationsResult;
import com.takipi.api.client.result.deployment.DeploymentsResult;
import com.takipi.api.client.result.server.ServersResult;
import com.takipi.api.client.result.service.ServicesResult;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ClientUtil {
    public static List<String> getDeployments(ApiClient apiClient, String serviceId) {
        return ClientUtil.getDeployments(apiClient, serviceId, false);
    }

    public static List<String> getDeployments(ApiClient apiClient, String serviceId, boolean active) {
        Collection<SummarizedDeployment> deployments = ClientUtil.getSummarizedDeployments(apiClient, serviceId, active);
        ArrayList<String> result = new ArrayList<String>(deployments.size());
        for (SummarizedDeployment deployment : deployments) {
            result.add(deployment.name);
        }
        return result;
    }

    public static Collection<SummarizedDeployment> getSummarizedDeployments(ApiClient apiClient, String serviceId, boolean active) {
        DeploymentsRequest request = DeploymentsRequest.newBuilder().setServiceId(serviceId).setActive(active).build();
        UrlClient.Response response = apiClient.get((ApiGetRequest)request);
        if (response.isBadResponse() || response.data == null) {
            throw new IllegalStateException("Could not acquire deployments for service " + serviceId + " . Error " + response.responseCode);
        }
        if (CollectionUtil.safeIsEmpty((Collection)((DeploymentsResult)response.data).deployments)) {
            return Collections.emptySet();
        }
        return ((DeploymentsResult)response.data).deployments;
    }

    public static List<String> getApplications(ApiClient apiClient, String serviceId) {
        return ClientUtil.getApplications(apiClient, serviceId, false);
    }

    public static List<String> getApplications(ApiClient apiClient, String serviceId, boolean active) {
        ApplicationsRequest request = ApplicationsRequest.newBuilder().setServiceId(serviceId).setActive(active).build();
        UrlClient.Response response = apiClient.get((ApiGetRequest)request);
        if (response.isBadResponse() || response.data == null) {
            throw new IllegalStateException("Could not acquire applications for service " + serviceId + " . Error " + response.responseCode);
        }
        if (((ApplicationsResult)response.data).applications == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(((ApplicationsResult)response.data).applications.size());
        for (SummarizedApplication app : ((ApplicationsResult)response.data).applications) {
            result.add(app.name);
        }
        return result;
    }

    public static List<String> getServers(ApiClient apiClient, String serviceId) {
        ServersRequest srvRequest = ServersRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response response = apiClient.get((ApiGetRequest)srvRequest);
        if (response.isBadResponse() || response.data == null) {
            throw new IllegalStateException("Could not acquire servers for service " + serviceId + " . Error " + response.responseCode);
        }
        if (((ServersResult)response.data).servers == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(((ServersResult)response.data).servers.size());
        for (SummarizedServer server : ((ServersResult)response.data).servers) {
            result.add(server.name);
        }
        return result;
    }

    public static List<SummarizedService> getEnvironments(ApiClient apiClient) {
        ServicesRequest request = ServicesRequest.newBuilder().build();
        UrlClient.Response response = apiClient.get((ApiGetRequest)request);
        if (response.isBadResponse() || response.data == null) {
            throw new IllegalStateException("Could not acquire services. Error " + response.responseCode);
        }
        if (((ServicesResult)response.data).services == null) {
            return Collections.emptyList();
        }
        return ((ServicesResult)response.data).services;
    }

    public static SummarizedService getEnvironment(ApiClient apiClient, String serviceId) {
        ServicesRequest request = ServicesRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response response = apiClient.get((ApiGetRequest)request);
        if (response.isBadResponse() || response.data == null || ((ServicesResult)response.data).services == null || ((ServicesResult)response.data).services.isEmpty()) {
            System.err.println("Could not acquire service. Error " + response.responseCode);
            return null;
        }
        return (SummarizedService)((ServicesResult)response.data).services.get(0);
    }
}

