/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.grafana;

import com.takipi.api.client.util.grafana.GrafanaDashboard;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.joda.time.DateTime;

public class GrafanaUrlBuilder {
    private static final String BASE_TEMPLATE = "%s/d/%s/%s?ordId=1";
    private static final String ENVS_PARAM = "var-environments";
    private static final String FROM_PARAM = "from";
    private static final String TO_PARAM = "to";
    private static final String APPS_PARAM = "var-applications";
    private static final String DEPS_PARAM = "var-deployments";
    private static final String MACHINES_PARAM = "var-servers";
    private static final String ALL_VALUE = "All";
    private final String grafanaHostname;
    private final GrafanaDashboard dashboard;
    private final Map<String, String> urlParams;
    private final Map<String, Collection<String>> urlListParams;

    private GrafanaUrlBuilder(String grafanaHostname, GrafanaDashboard dashboard) {
        this.grafanaHostname = grafanaHostname;
        this.dashboard = dashboard;
        this.urlParams = new HashMap<String, String>();
        this.urlListParams = new HashMap<String, Collection<String>>();
    }

    public GrafanaUrlBuilder withEnrivonment(String environmentName, String environmentId) {
        if (StringUtil.isNullOrEmpty((String)environmentId)) {
            this.urlParams.remove(ENVS_PARAM);
            return this;
        }
        if (StringUtil.isNullOrEmpty((String)environmentName)) {
            this.urlParams.put(ENVS_PARAM, environmentId);
        } else {
            this.urlParams.put(ENVS_PARAM, environmentName + ": " + environmentId);
        }
        return this;
    }

    public GrafanaUrlBuilder withParam(String param, String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            this.urlParams.remove(param);
            return this;
        }
        this.urlParams.put(param, value);
        return this;
    }

    public GrafanaUrlBuilder withParam(String param, DateTime value) {
        if (value == null) {
            this.urlParams.remove(param);
            return this;
        }
        this.urlParams.put(param, String.valueOf(value.getMillis()));
        return this;
    }

    public GrafanaUrlBuilder withListParam(String param, String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return this;
        }
        Collection<String> listParams = this.urlListParams.get(param);
        if (listParams == null) {
            listParams = new HashSet<String>();
            this.urlListParams.put(param, listParams);
        }
        listParams.add(value);
        return this;
    }

    public GrafanaUrlBuilder withListParams(String param, Collection<String> values) {
        if (CollectionUtil.safeIsEmpty(values)) {
            return this;
        }
        for (String value : values) {
            this.withListParam(param, value);
        }
        return this;
    }

    public GrafanaUrlBuilder withoutListParam(String param, String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return this;
        }
        Collection<String> listParams = this.urlListParams.get(param);
        if (listParams == null) {
            return this;
        }
        listParams.remove(value);
        return this;
    }

    public GrafanaUrlBuilder withFrom(String from) {
        return this.withParam(FROM_PARAM, from);
    }

    public GrafanaUrlBuilder withFrom(DateTime from) {
        return this.withParam(FROM_PARAM, from);
    }

    public GrafanaUrlBuilder withTo(String to) {
        return this.withParam(FROM_PARAM, to);
    }

    public GrafanaUrlBuilder withTo(DateTime to) {
        return this.withParam(TO_PARAM, to);
    }

    public GrafanaUrlBuilder withApplication(String application) {
        return this.withoutListParam(APPS_PARAM, ALL_VALUE).withListParam(APPS_PARAM, application);
    }

    public GrafanaUrlBuilder withApplications(Collection<String> applications) {
        if (CollectionUtil.safeIsEmpty(applications)) {
            return this;
        }
        return this.withoutListParam(APPS_PARAM, ALL_VALUE).withListParams(APPS_PARAM, applications);
    }

    public GrafanaUrlBuilder withDeployment(String deployment) {
        return this.withoutListParam(DEPS_PARAM, ALL_VALUE).withListParam(DEPS_PARAM, deployment);
    }

    public GrafanaUrlBuilder withDeployments(Collection<String> deployments) {
        if (CollectionUtil.safeIsEmpty(deployments)) {
            return this;
        }
        return this.withoutListParam(DEPS_PARAM, ALL_VALUE).withListParams(DEPS_PARAM, deployments);
    }

    public GrafanaUrlBuilder withMachine(String machine) {
        return this.withoutListParam(MACHINES_PARAM, ALL_VALUE).withListParam(MACHINES_PARAM, machine);
    }

    public GrafanaUrlBuilder withMachines(Collection<String> machines) {
        if (CollectionUtil.safeIsEmpty(machines)) {
            return this;
        }
        return this.withoutListParam(MACHINES_PARAM, ALL_VALUE).withListParams(MACHINES_PARAM, machines);
    }

    public String buildUrl() {
        String param;
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(BASE_TEMPLATE, this.grafanaHostname, this.dashboard.dashboardId, this.dashboard.dashboardName));
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            param = entry.getKey();
            String value = GrafanaUrlBuilder.safeUrlEncode(entry.getValue());
            builder.append('&');
            builder.append(param);
            if (StringUtil.isNullOrEmpty((String)value)) continue;
            builder.append('=');
            builder.append(value);
        }
        for (Map.Entry<String, Object> entry : this.urlListParams.entrySet()) {
            param = entry.getKey();
            Collection values = (Collection)entry.getValue();
            for (String rawValue : values) {
                String value = GrafanaUrlBuilder.safeUrlEncode(rawValue);
                if (StringUtil.isNullOrEmpty((String)value)) continue;
                builder.append('&');
                builder.append(param);
                builder.append('=');
                builder.append(value);
            }
        }
        return builder.toString();
    }

    private static String safeUrlEncode(String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return value;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static GrafanaUrlBuilder create(String grafanaHostname, GrafanaDashboard dashboard) {
        return new GrafanaUrlBuilder(grafanaHostname, dashboard).withListParam(APPS_PARAM, ALL_VALUE).withListParam(DEPS_PARAM, ALL_VALUE).withListParam(MACHINES_PARAM, ALL_VALUE);
    }
}

