/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.infra;

import com.google.gson.Gson;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.IOUtil;
import com.takipi.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Categories {
    private static final String DEFAULT_CATEGORIES = "/infra/categories.json";
    private static final Categories EMPTY_CATEGORIES = new Categories();
    private static volatile Categories instance = null;
    public List<Category> categories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Categories defaultCategories() {
        if (instance != null) return instance;
        Class<Categories> clazz = Categories.class;
        synchronized (Categories.class) {
            if (instance != null) return instance;
            Categories result = IOUtil.readFromResource(DEFAULT_CATEGORIES, Categories.class, new Gson());
            instance = result != null ? result : EMPTY_CATEGORIES;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Set<String> getCategories(String className, CategoryType type) {
        if (CollectionUtil.safeIsEmpty(this.categories)) {
            return Collections.emptySet();
        }
        for (Category category : this.categories) {
            if (CollectionUtil.safeIsEmpty(category.names) || CollectionUtil.safeIsEmpty(category.labels) || type != null && type != category.getType()) continue;
            for (String name : category.names) {
                if (!className.startsWith(name)) continue;
                return new HashSet<String>(category.labels);
            }
        }
        return Collections.emptySet();
    }

    public static Categories expandWithDefaultCategories(Collection<Category> categories) {
        if (CollectionUtil.safeIsEmpty(categories)) {
            return Categories.defaultCategories();
        }
        Categories result = new Categories();
        result.categories = new ArrayList<Category>(categories);
        List<Category> defaultCategories = Categories.defaultCategories().categories;
        if (defaultCategories != null) {
            result.categories.addAll(defaultCategories);
        }
        return result;
    }

    public static void fillMissingCategoryNames(Collection<Category> categories) {
        if (CollectionUtil.safeIsEmpty(categories)) {
            return;
        }
        block0: for (Category category : categories) {
            if (!CollectionUtil.safeIsEmpty(category.names)) continue;
            for (Category defaultCategory : Categories.defaultCategories().categories) {
                if (!Categories.doCategoriesMatch(category, defaultCategory)) continue;
                category.names = new ArrayList<String>(defaultCategory.names);
                continue block0;
            }
        }
    }

    private static boolean doCategoriesMatch(Category a, Category b) {
        if (CollectionUtil.safeIsEmpty(a.labels) || CollectionUtil.safeIsEmpty(b.labels)) {
            return false;
        }
        for (String label : a.labels) {
            if (StringUtil.isNullOrEmpty((String)label) || !b.labels.contains(label)) continue;
            return true;
        }
        return false;
    }

    public static class Category {
        public List<String> names;
        public List<String> labels;
        public CategoryType type;

        public CategoryType getType() {
            if (this.type == null) {
                return CategoryType.infra;
            }
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Category)) {
                return false;
            }
            Category other = (Category)o;
            if (this.getType() != other.getType()) {
                return false;
            }
            if (!CollectionUtil.equalCollections(this.names, other.names)) {
                return false;
            }
            return CollectionUtil.equalCollections(this.labels, other.labels);
        }

        public int hashCode() {
            if (CollectionUtil.safeIsEmpty(this.names)) {
                return super.hashCode();
            }
            return String.join((CharSequence)",", this.names).hashCode();
        }
    }

    public static enum CategoryType {
        app,
        infra;

    }
}

