/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.infra;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.event.Location;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.infra.Categories;
import com.takipi.api.client.util.infra.InfraUtil;
import com.takipi.common.util.CollectionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class Categorizer {
    protected abstract Categories.CategoryType getType();

    protected abstract boolean validateEvent(EventResult var1);

    protected abstract Collection<String> getTierLabels(EventResult var1, Categories var2);

    private void updateEventLabels(EventResult event, Collection<String> tierLabels, Collection<String> existingLabels, Collection<String> labelsToAdd, Collection<String> labelsToRemove, String serviceId, String categoryId, ApiClient apiClient) {
        if (CollectionUtil.safeIsEmpty(tierLabels)) {
            return;
        }
        for (String tierLabel : tierLabels) {
            String labelName = InfraUtil.toTierLabelName(tierLabel, this.getType());
            labelsToRemove.remove(labelName);
            if (CollectionUtil.safeContains((Collection)event.labels, (Object)labelName)) continue;
            labelsToAdd.add(labelName);
            if (!existingLabels.add(tierLabel)) continue;
            InfraUtil.validateTierView(tierLabel, this.getType(), categoryId, serviceId, apiClient);
        }
    }

    private void removeExistingTierLabels(EventResult event, Collection<String> labelsToRemove) {
        if (CollectionUtil.safeIsEmpty((Collection)event.labels)) {
            return;
        }
        for (String label : event.labels) {
            if (!label.endsWith(InfraUtil.getTierLabelPostfix(this.getType()))) continue;
            labelsToRemove.add(label);
        }
    }

    public void categorizeEvent(EventResult event, Categories categories, Collection<String> labelsToAdd, Collection<String> labelsToRemove, Collection<String> existingLabels, String serviceId, String categoryId, ApiClient apiClient) {
        if (event == null || !this.validateEvent(event)) {
            return;
        }
        this.removeExistingTierLabels(event, labelsToRemove);
        Collection<String> tierLabels = this.getTierLabels(event, categories);
        this.updateEventLabels(event, tierLabels, existingLabels, labelsToAdd, labelsToRemove, serviceId, categoryId, apiClient);
    }

    public static Categorizer get(Categories.CategoryType categoryType) {
        switch (categoryType) {
            case app: {
                return AppCategorizer.instance;
            }
            case infra: {
                return CodeTierCategorizer.instance;
            }
        }
        return null;
    }

    public static class CodeTierCategorizer
    extends Categorizer {
        public static final Categorizer instance = new CodeTierCategorizer();

        private CodeTierCategorizer() {
        }

        @Override
        protected Categories.CategoryType getType() {
            return Categories.CategoryType.infra;
        }

        @Override
        protected boolean validateEvent(EventResult event) {
            return event.error_origin != null;
        }

        @Override
        protected Collection<String> getTierLabels(EventResult event, Categories categories) {
            return categories.getCategories(event.error_origin.class_name, Categories.CategoryType.infra);
        }
    }

    public static class AppCategorizer
    extends Categorizer {
        public static final Categorizer instance = new AppCategorizer();

        private AppCategorizer() {
        }

        @Override
        protected Categories.CategoryType getType() {
            return Categories.CategoryType.app;
        }

        @Override
        protected boolean validateEvent(EventResult event) {
            return !CollectionUtil.safeIsEmpty((Collection)event.stack_frames);
        }

        @Override
        protected Collection<String> getTierLabels(EventResult event, Categories categories) {
            HashSet<String> appLabels = new HashSet<String>();
            for (Location location : event.stack_frames) {
                Set<String> frameMatches = categories.getCategories(location.class_name, Categories.CategoryType.app);
                appLabels.addAll(frameMatches);
            }
            return appLabels;
        }
    }
}

