/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.infra;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.data.view.ViewFilters;
import com.takipi.api.client.data.view.ViewInfo;
import com.takipi.api.client.request.event.EventModifyLabelsRequest;
import com.takipi.api.client.request.event.EventRequest;
import com.takipi.api.client.request.label.CreateLabelRequest;
import com.takipi.api.client.request.view.CreateViewRequest;
import com.takipi.api.client.request.view.ViewsRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.view.CreateViewResult;
import com.takipi.api.client.result.view.ViewsResult;
import com.takipi.api.client.util.category.CategoryUtil;
import com.takipi.api.client.util.infra.Categories;
import com.takipi.api.client.util.infra.Categorizer;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.Pair;
import com.takipi.common.util.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InfraUtil {
    private static final String TIER_LABEL_SEPERATOR = ".";

    public static void categorizeEvent(String eventId, String serviceId, Map<Categories.CategoryType, String> categoryIds, Categories categories, Set<String> existingLabels, ApiClient apiClient, boolean applyLabels, boolean handleSimilarEvents) {
        boolean includeStacktrace = categoryIds.containsKey((Object)Categories.CategoryType.app);
        EventRequest metadataRequest = EventRequest.newBuilder().setEventId(eventId).setServiceId(serviceId).setIncludeStacktrace(includeStacktrace).build();
        UrlClient.Response metadataResult = apiClient.get((ApiGetRequest)metadataRequest);
        if (metadataResult.isBadResponse()) {
            throw new IllegalStateException("Can't apply infrastructure routing to event " + eventId);
        }
        InfraUtil.categorizeEvent((EventResult)metadataResult.data, serviceId, categoryIds, categories, existingLabels, apiClient, applyLabels, handleSimilarEvents);
    }

    public static Pair<Collection<String>, Collection<String>> categorizeEvent(EventResult event, String serviceId, Map<Categories.CategoryType, String> categoryIds, Categories categories, Set<String> existingLabels, ApiClient apiClient, boolean applyLabels, boolean handleSimilarEvents) {
        EventModifyLabelsRequest labelsRequest;
        UrlClient.Response addResult;
        if (event == null) {
            return Pair.of(Collections.emptySet(), Collections.emptySet());
        }
        HashSet<String> labelsToAdd = new HashSet<String>();
        HashSet<String> labelsToRemove = new HashSet<String>();
        for (Map.Entry<Categories.CategoryType, String> entry : categoryIds.entrySet()) {
            Categories.CategoryType categoryType = entry.getKey();
            Categorizer categorizer = Categorizer.get(categoryType);
            if (categorizer == null) continue;
            String categoryId = entry.getValue();
            categorizer.categorizeEvent(event, categories, labelsToAdd, labelsToRemove, existingLabels, serviceId, categoryId, apiClient);
        }
        if (!applyLabels) {
            return Pair.of(labelsToAdd, labelsToRemove);
        }
        if (!(labelsToAdd.isEmpty() && labelsToRemove.isEmpty() || !(addResult = apiClient.post((ApiPostRequest)(labelsRequest = EventModifyLabelsRequest.newBuilder().setServiceId(serviceId).setEventId(event.id).setHandleSimilarEvents(handleSimilarEvents).addLabels(labelsToAdd).removeLabels(labelsToRemove).build()))).isBadResponse())) {
            throw new IllegalStateException("Can't apply labels to event " + event.id);
        }
        return Pair.of(labelsToAdd, labelsToRemove);
    }

    public static void validateTierView(String locationLabel, Categories.CategoryType type, String categoryId, String serviceId, ApiClient apiClient) {
        InfraUtil.createTierLabel(locationLabel, type, serviceId, apiClient);
        String viewId = InfraUtil.createTierView(locationLabel, type, serviceId, apiClient);
        CategoryUtil.addViewToCategory(categoryId, viewId, serviceId, apiClient);
    }

    private static boolean createTierLabel(String labelName, Categories.CategoryType type, String serviceId, ApiClient apiClient) {
        String tierLabelName = InfraUtil.toTierLabelName(labelName, type);
        CreateLabelRequest createLabelRequest = CreateLabelRequest.newBuilder().setServiceId(serviceId).setName(tierLabelName).build();
        UrlClient.Response createResponse = apiClient.post((ApiPostRequest)createLabelRequest);
        if (createResponse.isBadResponse() && createResponse.responseCode != 409) {
            throw new IllegalStateException("Can't create label " + tierLabelName);
        }
        return createResponse.responseCode == 409;
    }

    private static String createTierView(String labelName, Categories.CategoryType type, String serviceId, ApiClient apiClient) {
        ViewFilters viewFilters = new ViewFilters();
        viewFilters.labels = Collections.singletonList(InfraUtil.toTierLabelName(labelName, type));
        ViewInfo viewInfo = new ViewInfo();
        viewInfo.name = labelName;
        viewInfo.shared = true;
        viewInfo.filters = viewFilters;
        viewInfo.immutable = true;
        CreateViewRequest createViewRequest = CreateViewRequest.newBuilder().setServiceId(serviceId).setViewInfo(viewInfo).build();
        UrlClient.Response createViewResponse = apiClient.post((ApiPostRequest)createViewRequest);
        if (createViewResponse.isOK()) {
            CreateViewResult createViewResult = (CreateViewResult)createViewResponse.data;
            if (createViewResult == null || StringUtil.isNullOrEmpty((String)createViewResult.view_id)) {
                throw new IllegalStateException("Failed creating view - " + labelName);
            }
            return createViewResult.view_id;
        }
        if (createViewResponse.responseCode != 409) {
            throw new IllegalStateException("Failed creating view - " + labelName);
        }
        ViewsRequest getViewsRequest = ViewsRequest.newBuilder().setServiceId(serviceId).setViewName(labelName).build();
        UrlClient.Response getViewsResponse = apiClient.get((ApiGetRequest)getViewsRequest);
        if (getViewsResponse.isBadResponse() || getViewsResponse.data == null || CollectionUtil.safeIsEmpty((Collection)((ViewsResult)getViewsResponse.data).views)) {
            throw new IllegalStateException("Failed getting view - " + labelName);
        }
        SummarizedView view = (SummarizedView)((ViewsResult)getViewsResponse.data).views.get(0);
        if (!labelName.equalsIgnoreCase(view.name) || StringUtil.isNullOrEmpty((String)view.id)) {
            throw new IllegalStateException("Failed getting view - " + labelName);
        }
        return view.id;
    }

    public static String getTierLabelPostfix(Categories.CategoryType type) {
        return TIER_LABEL_SEPERATOR + type.toString().toLowerCase();
    }

    public static String getTierNameFromLabel(String tierName, Categories.CategoryType type) {
        String postfix = InfraUtil.getTierLabelPostfix(type);
        if (tierName == null || tierName.isEmpty() || !tierName.endsWith(postfix)) {
            return null;
        }
        String result = tierName.substring(0, tierName.length() - postfix.length());
        return result;
    }

    public static String toTierLabelName(String tierName, Categories.CategoryType type) {
        return tierName + InfraUtil.getTierLabelPostfix(type);
    }
}

