/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.label;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.label.Label;
import com.takipi.api.client.request.label.CreateLabelRequest;
import com.takipi.api.client.request.label.LabelsRequest;
import com.takipi.api.client.result.label.LabelsResult;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LabelUtil {
    public static Map<String, Label> getServiceLabels(ApiClient apiClient, String serviceId) {
        LabelsRequest viewsRequest = LabelsRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response labelsResponse = apiClient.get((ApiGetRequest)viewsRequest);
        if (labelsResponse.isBadResponse() || labelsResponse.data == null || ((LabelsResult)labelsResponse.data).labels == null) {
            System.err.println("Can't list labels");
            return Collections.emptyMap();
        }
        HashMap<String, Label> result = new HashMap<String, Label>();
        for (Label label : ((LabelsResult)labelsResponse.data).labels) {
            result.put(label.name, label);
        }
        return result;
    }

    public static void createLabelsIfNotExists(ApiClient apiClient, String serviceId, String[] labelNames) {
        Map<String, Label> existingLabels = LabelUtil.getServiceLabels(apiClient, serviceId);
        for (String labelName : labelNames) {
            if (existingLabels.containsKey(labelName)) {
                System.out.println("label " + labelName + " found");
                continue;
            }
            CreateLabelRequest createLabelRequest = CreateLabelRequest.newBuilder().setServiceId(serviceId).setName(labelName).build();
            UrlClient.Response labelResponse = apiClient.post((ApiPostRequest)createLabelRequest);
            if (!labelResponse.isBadResponse()) continue;
            System.err.println("Cannot create label " + labelName);
        }
    }
}

