/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.performance;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.transaction.Transaction;
import com.takipi.api.client.request.event.EventModifyLabelsRequest;
import com.takipi.api.client.request.label.CreateLabelRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.performance.calc.PerformanceCalculator;
import com.takipi.api.client.util.performance.calc.PerformanceScore;
import com.takipi.api.client.util.performance.calc.PerformanceState;
import com.takipi.api.client.util.transaction.TransactionUtil;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.Pair;
import com.takipi.common.util.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public class PerformanceUtil {
    private static final String PERF_SUFFIX = ".perf";

    public static Map<Transaction, PerformanceScore> getTransactionStates(Collection<Transaction> activeTransactions, Collection<Transaction> baselineTransactions, PerformanceCalculator<Transaction, Transaction> calculator) {
        return PerformanceUtil.getTransactionStates(TransactionUtil.getTransactionsMap(activeTransactions), TransactionUtil.getTransactionsMap(baselineTransactions), calculator);
    }

    public static Map<Transaction, PerformanceScore> getTransactionStates(ApiClient apiClient, String serviceId, String viewId, PerformanceCalculator<Transaction, Transaction> calculator, int baselineTimespanMinutes, int activeTimespanMinutes) {
        DateTime now = DateTime.now();
        Map<String, Transaction> activeTransactions = TransactionUtil.getTransactions(apiClient, serviceId, viewId, now, activeTimespanMinutes);
        if (CollectionUtil.safeIsEmpty(activeTransactions)) {
            return Collections.emptyMap();
        }
        Map<String, Transaction> baselineTransactions = TransactionUtil.getTransactions(apiClient, serviceId, viewId, now, baselineTimespanMinutes);
        return PerformanceUtil.getTransactionStates(activeTransactions, baselineTransactions, calculator);
    }

    public static Map<Transaction, PerformanceScore> getTransactionStates(Map<String, Transaction> activeTransactions, Map<String, Transaction> baselineTransactions, PerformanceCalculator<Transaction, Transaction> calculator) {
        return PerformanceUtil.getPerformanceStates(activeTransactions, baselineTransactions, calculator);
    }

    public static <T, S> Map<T, PerformanceScore> getPerformanceStates(Map<String, T> activeTargets, Map<String, S> baselineTargets, PerformanceCalculator<T, S> calculator) {
        if (CollectionUtil.safeIsEmpty(activeTargets)) {
            return Collections.emptyMap();
        }
        HashMap<T, PerformanceScore> result = new HashMap<T, PerformanceScore>(activeTargets.size());
        if (CollectionUtil.safeIsEmpty(baselineTargets)) {
            for (Map.Entry<String, T> entry : activeTargets.entrySet()) {
                result.put(entry.getValue(), PerformanceScore.NO_DATA);
            }
            return result;
        }
        for (Map.Entry<String, T> entry : activeTargets.entrySet()) {
            String name = entry.getKey();
            T active = entry.getValue();
            S baseline = baselineTargets.get(name);
            if (baseline == null) {
                result.put(active, PerformanceScore.NO_DATA);
                continue;
            }
            PerformanceScore score = calculator.calc(active, baseline);
            result.put(active, score);
        }
        return result;
    }

    public static Pair<Collection<String>, Collection<String>> categorizeEvent(EventResult event, String serviceId, PerformanceState state, Set<String> existingLabels, ApiClient apiClient, boolean applyLabels) {
        EventModifyLabelsRequest labelsRequest;
        UrlClient.Response addResult;
        Set labelsToAdd;
        if (event == null) {
            return Pair.of(Collections.emptySet(), Collections.emptySet());
        }
        HashSet<String> labelsToRemove = new HashSet<String>();
        if (!CollectionUtil.safeIsEmpty((Collection)event.labels)) {
            for (String currentLabel : event.labels) {
                if (!currentLabel.endsWith(PERF_SUFFIX)) continue;
                labelsToRemove.add(currentLabel);
            }
        }
        if (state != PerformanceState.NO_DATA) {
            labelsToAdd = new HashSet();
            String labelName = PerformanceUtil.getLabelName(state);
            if (!StringUtil.isNullOrEmpty((String)labelName)) {
                String perfLabelName = PerformanceUtil.toInternalPerfLabelName(labelName);
                labelsToRemove.remove(perfLabelName);
                if (!CollectionUtil.safeContains((Collection)event.labels, (Object)perfLabelName)) {
                    labelsToAdd.add(perfLabelName);
                    if (existingLabels.add(labelName)) {
                        PerformanceUtil.createPerfLabel(labelName, serviceId, apiClient);
                    }
                }
            }
        } else {
            labelsToAdd = Collections.emptySet();
        }
        if (!applyLabels) {
            return Pair.of(labelsToAdd, labelsToRemove);
        }
        if (!(labelsToAdd.isEmpty() && labelsToRemove.isEmpty() || !(addResult = apiClient.post((ApiPostRequest)(labelsRequest = EventModifyLabelsRequest.newBuilder().setServiceId(serviceId).setEventId(event.id).addLabels(labelsToAdd).removeLabels(labelsToRemove).build()))).isBadResponse())) {
            throw new IllegalStateException("Can't apply labels to event " + event.id);
        }
        return Pair.of(labelsToAdd, labelsToRemove);
    }

    private static String getLabelName(PerformanceState state) {
        switch (state) {
            case NO_DATA: {
                return null;
            }
            case OK: {
                return "OK";
            }
            case SLOWING: {
                return "Slowing";
            }
            case CRITICAL: {
                return "Critical";
            }
        }
        return null;
    }

    private static boolean createPerfLabel(String labelName, String serviceId, ApiClient apiClient) {
        String infraLabelName = PerformanceUtil.toInternalPerfLabelName(labelName);
        CreateLabelRequest createLabelRequest = CreateLabelRequest.newBuilder().setServiceId(serviceId).setName(infraLabelName).build();
        UrlClient.Response createResponse = apiClient.post((ApiPostRequest)createLabelRequest);
        if (createResponse.isBadResponse() && createResponse.responseCode != 409) {
            throw new IllegalStateException("Can't create label " + infraLabelName);
        }
        return createResponse.responseCode == 409;
    }

    private static String toInternalPerfLabelName(String labelName) {
        return labelName + PERF_SUFFIX;
    }
}

