/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.performance.transaction;

import com.takipi.api.client.data.transaction.Stats;
import com.takipi.api.client.data.transaction.TransactionGraph;
import com.takipi.api.client.util.performance.calc.PerformanceCalculator;
import com.takipi.api.client.util.performance.calc.PerformanceScore;
import com.takipi.api.client.util.performance.calc.PerformanceState;
import com.takipi.api.client.util.transaction.TransactionUtil;

public abstract class BaseGraphPerformanceCalculator<S>
implements PerformanceCalculator<TransactionGraph, S> {
    private final long activeInvocationsThreshold;
    private final long baselineInvocationsThreshold;
    private final int minDeltaThreshold;
    private final double minDeltaThresholdPercentage;
    private final double overAvgSlowingPercentage;
    private final double overAvgCriticalPercentage;
    private final double stdDevFactor;
    private final long maxAvgTimeThreshold;

    protected BaseGraphPerformanceCalculator(long activeInvocationsThreshold, long baselineInvocationsThreshold, int minDeltaThreshold, double minDeltaThresholdPercentage, double overAvgSlowingPercentage, double overAvgCriticalPercentage, double stdDevFactor, long maxAvgTimeThreshold) {
        this.activeInvocationsThreshold = activeInvocationsThreshold;
        this.baselineInvocationsThreshold = baselineInvocationsThreshold;
        this.minDeltaThreshold = minDeltaThreshold;
        this.minDeltaThresholdPercentage = minDeltaThresholdPercentage;
        this.overAvgSlowingPercentage = overAvgSlowingPercentage;
        this.overAvgCriticalPercentage = overAvgCriticalPercentage;
        this.stdDevFactor = stdDevFactor;
        this.maxAvgTimeThreshold = maxAvgTimeThreshold;
    }

    protected PerformanceScore doCalc(TransactionGraph active, Stats baselineStats) {
        Stats activeStats = TransactionUtil.aggregateGraph(active);
        if (activeStats.invocations < this.activeInvocationsThreshold || baselineStats.invocations < this.baselineInvocationsThreshold || baselineStats.avg_time <= 0.0 || activeStats.avg_time > (double)this.maxAvgTimeThreshold) {
            return PerformanceScore.NO_DATA;
        }
        double badPointsScore = 0.0;
        double threshold = baselineStats.avg_time + baselineStats.avg_time_std_deviation * this.stdDevFactor;
        for (TransactionGraph.GraphPoint p : active.points) {
            if (p.stats == null || p.stats.avg_time < threshold) continue;
            double pointScore = (double)p.stats.invocations / (double)activeStats.invocations;
            badPointsScore += pointScore;
        }
        double slowingPercentage = badPointsScore * 100.0;
        if (this.passesSlowThreshold(activeStats, baselineStats)) {
            if (badPointsScore >= this.overAvgCriticalPercentage) {
                return PerformanceScore.of(PerformanceState.CRITICAL, slowingPercentage);
            }
            if (badPointsScore >= this.overAvgSlowingPercentage) {
                return PerformanceScore.of(PerformanceState.SLOWING, slowingPercentage);
            }
        }
        return PerformanceScore.of(PerformanceState.OK, slowingPercentage);
    }

    private boolean passesSlowThreshold(Stats activeStats, Stats baselineStats) {
        if (activeStats.avg_time - baselineStats.avg_time <= (double)this.minDeltaThreshold) {
            return false;
        }
        double percentageIncrease = (activeStats.avg_time - baselineStats.avg_time) / baselineStats.avg_time;
        return percentageIncrease >= this.minDeltaThresholdPercentage;
    }
}

