/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.performance.transaction;

import com.takipi.api.client.data.transaction.Stats;
import com.takipi.api.client.data.transaction.TransactionGraph;
import com.takipi.api.client.util.performance.calc.PerformanceScore;
import com.takipi.api.client.util.performance.transaction.BaseGraphPerformanceCalculator;
import com.takipi.api.client.util.transaction.TransactionUtil;
import com.takipi.common.util.CollectionUtil;
import java.util.Collection;

public class GraphPerformanceCalculator
extends BaseGraphPerformanceCalculator<TransactionGraph> {
    private GraphPerformanceCalculator(long activeInvocationsThreshold, long baselineInvocationsThreshold, int minDeltaThreshold, double minDeltaThresholdPercentage, double overAvgSlowingPercentage, double overAvgCriticalPercentage, double stdDevFactor, long maxAvgTimeThreshold) {
        super(activeInvocationsThreshold, baselineInvocationsThreshold, minDeltaThreshold, minDeltaThresholdPercentage, overAvgSlowingPercentage, overAvgCriticalPercentage, stdDevFactor, maxAvgTimeThreshold);
    }

    @Override
    public PerformanceScore calc(TransactionGraph active, TransactionGraph baseline) {
        if (active == null || CollectionUtil.safeIsEmpty((Collection)active.points) || baseline == null || CollectionUtil.safeIsEmpty((Collection)baseline.points)) {
            return PerformanceScore.NO_DATA;
        }
        Stats baselineStats = TransactionUtil.aggregateGraph(baseline);
        return this.doCalc(active, baselineStats);
    }

    public static GraphPerformanceCalculator of(long activeInvocationsThreshold, long baselineInvocationsThreshold, int minDeltaThreshold, double minDeltaThresholdPercentage, double overAvgSlowingPercentage, double overAvgCriticalPercentage, double stdDevFactor, long maxAvgTimeThreshold) {
        return new GraphPerformanceCalculator(activeInvocationsThreshold, baselineInvocationsThreshold, minDeltaThreshold, minDeltaThresholdPercentage, overAvgSlowingPercentage, overAvgCriticalPercentage, stdDevFactor, maxAvgTimeThreshold);
    }
}

