/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.performance.transaction;

import com.takipi.api.client.data.transaction.Transaction;
import com.takipi.api.client.data.transaction.TransactionGraph;
import com.takipi.api.client.util.performance.calc.PerformanceScore;
import com.takipi.api.client.util.performance.transaction.BaseGraphPerformanceCalculator;
import com.takipi.common.util.CollectionUtil;
import java.util.Collection;

public class HybridPerformanceCalculator
extends BaseGraphPerformanceCalculator<Transaction> {
    private HybridPerformanceCalculator(long activeInvocationsThreshold, long baselineInvocationsThreshold, int minDeltaThreshold, double minDeltaThresholdPercentage, double overAvgSlowingPercentage, double overAvgCriticalPercentage, double stdDevFactor, long maxAvgTimeThreshold) {
        super(activeInvocationsThreshold, baselineInvocationsThreshold, minDeltaThreshold, minDeltaThresholdPercentage, overAvgSlowingPercentage, overAvgCriticalPercentage, stdDevFactor, maxAvgTimeThreshold);
    }

    @Override
    public PerformanceScore calc(TransactionGraph active, Transaction baseline) {
        if (active == null || CollectionUtil.safeIsEmpty((Collection)active.points) || baseline == null || baseline.stats == null) {
            return PerformanceScore.NO_DATA;
        }
        return this.doCalc(active, baseline.stats);
    }

    public static HybridPerformanceCalculator of(long activeInvocationsThreshold, long baselineInvocationsThreshold, int minDeltaThreshold, double minDeltaThresholdPercentage, double overAvgSlowingPercentage, double overAvgCriticalPercentage, double stdDevFactor, long maxAvgTimeThreshold) {
        return new HybridPerformanceCalculator(activeInvocationsThreshold, baselineInvocationsThreshold, minDeltaThreshold, minDeltaThresholdPercentage, overAvgSlowingPercentage, overAvgCriticalPercentage, stdDevFactor, maxAvgTimeThreshold);
    }
}

