/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.regression;

import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.regression.RegressionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class RateRegression {
    private final Map<String, EventResult> allNewEvents;
    private final Map<String, RegressionResult> allRegressions;
    private final Map<String, RegressionResult> criticalRegressions;
    private final Map<String, EventResult> exceededNewEvents;
    private final Map<String, EventResult> criticalNewEvents;
    private final List<EventResult> nonRegressions;
    private final DateTime activeWndowStart;

    RateRegression(Map<String, EventResult> allNewEvents, Map<String, RegressionResult> allRegressions, Map<String, RegressionResult> criticalRegressions, Map<String, EventResult> exceededNewEvents, Map<String, EventResult> criticalNewEvents, DateTime activeWndowStart, List<EventResult> nonRegressions) {
        this.activeWndowStart = activeWndowStart;
        this.allRegressions = Collections.unmodifiableMap(allRegressions);
        this.criticalNewEvents = Collections.unmodifiableMap(criticalNewEvents);
        this.exceededNewEvents = Collections.unmodifiableMap(exceededNewEvents);
        this.allNewEvents = Collections.unmodifiableMap(allNewEvents);
        this.criticalRegressions = Collections.unmodifiableMap(criticalRegressions);
        this.nonRegressions = Collections.unmodifiableList(nonRegressions);
    }

    private static List<RegressionResult> getSortedRegressions(Collection<RegressionResult> regressions) {
        ArrayList<RegressionResult> result = new ArrayList<RegressionResult>(regressions);
        result.sort(new Comparator<RegressionResult>(){

            @Override
            public int compare(RegressionResult o1, RegressionResult o2) {
                return (int)(o2.getEvent().stats.hits - o1.getEvent().stats.hits);
            }
        });
        return result;
    }

    public static List<EventResult> getSortedNewEvents(Collection<EventResult> events) {
        ArrayList<EventResult> result = new ArrayList<EventResult>(events);
        result.sort(new Comparator<EventResult>(){

            @Override
            public int compare(EventResult o1, EventResult o2) {
                return (int)(o2.stats.hits - o1.stats.hits);
            }
        });
        return result;
    }

    public DateTime getActiveWndowStart() {
        return this.activeWndowStart;
    }

    public Collection<EventResult> getSortedNonRegressions() {
        return RateRegression.getSortedNewEvents(this.nonRegressions);
    }

    public Collection<EventResult> getSortedAllNewEvents() {
        return RateRegression.getSortedNewEvents(this.allNewEvents.values());
    }

    public Collection<RegressionResult> getSortedAllRegressions() {
        return RateRegression.getSortedRegressions(this.allRegressions.values());
    }

    public Collection<RegressionResult> getSortedCriticalRegressions() {
        return RateRegression.getSortedRegressions(this.criticalRegressions.values());
    }

    public Collection<EventResult> getSortedExceededNewEvents() {
        return RateRegression.getSortedNewEvents(this.exceededNewEvents.values());
    }

    public Collection<EventResult> getSortedCriticalNewEvents() {
        return RateRegression.getSortedNewEvents(this.criticalNewEvents.values());
    }

    public Collection<EventResult> getNonRegressions() {
        return this.nonRegressions;
    }

    public Map<String, EventResult> getAllNewEvents() {
        return this.allNewEvents;
    }

    public Map<String, RegressionResult> getAllRegressions() {
        return this.allRegressions;
    }

    public Map<String, RegressionResult> getCriticalRegressions() {
        return this.criticalRegressions;
    }

    public Map<String, EventResult> getExceededNewEvents() {
        return this.exceededNewEvents;
    }

    public Map<String, EventResult> getCriticalNewEvents() {
        return this.criticalNewEvents;
    }

    public static class Builder {
        private final Map<String, EventResult> allNewEvents;
        private final Map<String, RegressionResult> allRegressions = new HashMap<String, RegressionResult>();
        private final Map<String, RegressionResult> criticalRegressions;
        private final Map<String, EventResult> exceededNewEvents;
        private final Map<String, EventResult> criticalNewEvents = new HashMap<String, EventResult>();
        private final List<EventResult> nonRegressions;
        private DateTime activeWindowStart;

        Builder() {
            this.exceededNewEvents = new HashMap<String, EventResult>();
            this.allNewEvents = new HashMap<String, EventResult>();
            this.criticalRegressions = new HashMap<String, RegressionResult>();
            this.nonRegressions = new ArrayList<EventResult>();
        }

        public void setActiveWindowStart(DateTime activeWindowStart) {
            this.activeWindowStart = activeWindowStart;
        }

        public void addNonRegressions(EventResult event) {
            this.nonRegressions.add(event);
        }

        public void addNewEvent(String id, EventResult event) {
            this.allNewEvents.put(id, event);
        }

        public void addExceededNewEvent(String id, EventResult event) {
            this.exceededNewEvents.put(id, event);
        }

        public void addCriticalNewEvent(String id, EventResult event) {
            this.criticalNewEvents.put(id, event);
        }

        public void addRegression(String id, EventResult event, long baselineHits, long baselineInvocations) {
            this.allRegressions.put(id, RegressionResult.of(event, baselineHits, baselineInvocations));
        }

        public void addCriticalRegression(String id, EventResult event, long baselineHits, long baselineInvocations) {
            this.criticalRegressions.put(id, RegressionResult.of(event, baselineHits, baselineInvocations));
        }

        public RateRegression build() {
            return new RateRegression(this.allNewEvents, this.allRegressions, this.criticalRegressions, this.exceededNewEvents, this.criticalNewEvents, this.activeWindowStart, this.nonRegressions);
        }
    }
}

