/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.regression;

import com.takipi.api.client.data.metrics.Graph;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.common.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.joda.time.DateTime;

public class RegressionInput {
    public String serviceId;
    public String viewId;
    public DateTime activeWindowStart;
    public int activeTimespan;
    public int baselineTimespan;
    public String baselineTime;
    public int minVolumeThreshold;
    public double minErrorRateThreshold;
    public double regressionDelta;
    public double criticalRegressionDelta;
    public boolean applySeasonality;
    public Collection<String> criticalExceptionTypes;
    public Map<String, TypeThresholds> typeThresholdsMap;
    public Collection<String> applictations;
    public Collection<String> deployments;
    public Collection<String> servers;
    public Collection<EventResult> events;
    public Graph baselineGraph;

    private static void appendCollection(StringBuilder builder, String name, Collection<String> value, boolean newline) {
        builder.append(name);
        builder.append(" = ");
        if (value != null && value.size() > 0) {
            builder.append(Arrays.toString(value.toArray()));
        } else {
            builder.append("");
        }
        if (newline) {
            builder.append("\n");
        }
    }

    private static void appendVariable(StringBuilder builder, String name, Object value) {
        builder.append(name);
        builder.append(" = ");
        builder.append(value);
        builder.append("\n");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        RegressionInput.appendVariable(result, "Environment ID", this.serviceId);
        RegressionInput.appendVariable(result, "View ID", this.viewId);
        RegressionInput.appendVariable(result, "Active Timespan", this.activeTimespan);
        RegressionInput.appendVariable(result, "Baseline Timespan", this.baselineTimespan);
        RegressionInput.appendVariable(result, "Min Volume Threshold", this.minVolumeThreshold);
        RegressionInput.appendVariable(result, "Min Rate Threshold", this.minErrorRateThreshold);
        RegressionInput.appendVariable(result, "Regression Delta", this.regressionDelta);
        RegressionInput.appendVariable(result, "Critical Regression Delta", this.criticalRegressionDelta);
        RegressionInput.appendVariable(result, "Apply Seasonality", this.applySeasonality);
        RegressionInput.appendCollection(result, "Critical Exception Types", this.criticalExceptionTypes, true);
        RegressionInput.appendCollection(result, "Deployments", this.deployments, true);
        RegressionInput.appendCollection(result, "Applications", this.applictations, true);
        RegressionInput.appendCollection(result, "Servers", this.servers, false);
        return result.toString();
    }

    public void validate() {
        if (this.serviceId == null || this.serviceId.isEmpty()) {
            throw new IllegalStateException("Missing Environment Id");
        }
        if (this.viewId == null || this.viewId.isEmpty()) {
            throw new IllegalStateException("Missing View Id");
        }
        if (this.activeTimespan < 0) {
            throw new IllegalStateException("Negative Active timespan");
        }
        if (CollectionUtil.safeIsEmpty(this.deployments) && this.activeTimespan == 0) {
            throw new IllegalStateException("Either active timespan or deployment name must be provided");
        }
        if (this.baselineTimespan <= 0) {
            throw new IllegalStateException("Missing Baseline timespan");
        }
        if (this.regressionDelta < 0.0) {
            throw new IllegalStateException("Negative Regression Delta");
        }
        if (this.criticalRegressionDelta < 0.0) {
            throw new IllegalStateException("Negative Critical Regression Delta");
        }
    }

    public double getEventMinThreshold(EventResult event) {
        if (this.typeThresholdsMap == null) {
            return this.minVolumeThreshold;
        }
        TypeThresholds typeThresholds = this.typeThresholdsMap.get(event.type);
        if (typeThresholds != null) {
            return typeThresholds.minVolumeThreshold;
        }
        return this.minVolumeThreshold;
    }

    public double getEventMinErrorRateThreshold(EventResult event) {
        if (this.typeThresholdsMap == null) {
            return this.minErrorRateThreshold;
        }
        TypeThresholds typeThresholds = this.typeThresholdsMap.get(event.type);
        if (typeThresholds != null) {
            return typeThresholds.minErrorRateThreshold;
        }
        return this.minErrorRateThreshold;
    }

    public double getEventRegressionDelta(EventResult event) {
        if (this.typeThresholdsMap == null) {
            return this.regressionDelta;
        }
        TypeThresholds typeThresholds = this.typeThresholdsMap.get(event.type);
        if (typeThresholds != null) {
            return typeThresholds.regressionDelta;
        }
        return this.regressionDelta;
    }

    public double getEventCriticalRegressionDelta(EventResult event) {
        if (this.typeThresholdsMap == null) {
            return this.criticalRegressionDelta;
        }
        TypeThresholds typeThresholds = this.typeThresholdsMap.get(event.type);
        if (typeThresholds != null) {
            return typeThresholds.criticalRegressionDelta;
        }
        return this.criticalRegressionDelta;
    }

    public static class TypeThresholds {
        public int minVolumeThreshold;
        public double minErrorRateThreshold;
        public double regressionDelta;
        public double criticalRegressionDelta;
    }
}

