/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.regression;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.deployment.SummarizedDeployment;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionResult;
import com.takipi.api.client.util.regression.RegressionUtil;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.ocpsoft.prettytime.PrettyTime;

public class RegressionStringUtil {
    private static final String DEPLOYMENT_FORMAT = "%s first seen %s against a baseline of %s";
    private static final String TIME_WINDOW_FORMAT = "last %s against a baseline of %s";
    private static final String NOW_WINDOW_FORMAT = " time range vs. baseline of %s";
    public static final String NEW_ISSUE = "New";
    public static final String RESURFACED_ISSUE = "Resurfaced";
    public static final String SEVERE_NEW = "Severe New";
    public static final String REGRESSION = "Regression";
    public static final String SEVERE_REGRESSION = "Severe Regression";
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.00");
    private static final int MAX_MESSAGE_LENGTH = 100;

    public static String getEventSummary(EventResult event) {
        String message;
        if (event.message != null && event.message.trim().length() > 0 && !event.message.equals(event.name)) {
            String messageBody = event.message.length() > 100 ? event.message.substring(0, 100) + "..." : event.message;
            message = ": " + messageBody;
        } else if (event.error_location != null) {
            String[] parts = event.error_location.class_name.split(Pattern.quote("."));
            String simpleClassName = parts.length > 0 ? parts[parts.length - 1] : event.error_location.class_name;
            message = " in " + simpleClassName + "." + event.error_location.method_name;
        } else {
            message = "";
        }
        String result = event.name + message;
        return result;
    }

    public static String getEventRate(EventResult event) {
        return RegressionStringUtil.getEventRate(event, false);
    }

    public static String getEventRate(EventResult event, boolean fullText) {
        if (event.stats.invocations == 0L || event.stats.hits == 0L) {
            return "1";
        }
        StringBuilder result = new StringBuilder();
        double rate = (double)event.stats.hits / (double)event.stats.invocations * 100.0;
        result.append(event.stats.hits);
        if (fullText) {
            result.append(" errors in ");
        } else {
            result.append("/");
        }
        result.append(event.stats.invocations);
        if (fullText) {
            result.append(" calls");
        }
        result.append(" (");
        if (rate != (double)((int)rate)) {
            String fmt = decimalFormat.format(rate);
            if (fmt.startsWith(".")) {
                result.append("0");
            }
            result.append(fmt);
        } else {
            result.append((int)rate);
        }
        result.append("%)");
        return result.toString();
    }

    public static String getRegressedEventRate(RegressionResult regressionResult) {
        return RegressionStringUtil.getRegressedEventRate(regressionResult, false);
    }

    public static String getRegressedEventRate(RegressionResult regressionResult, boolean fullText) {
        return RegressionStringUtil.getRegressedEventRate(regressionResult.getEvent(), regressionResult.getBaselineHits(), regressionResult.getBaselineInvocations(), fullText);
    }

    public static String getRegressedEventRate(EventResult event, long baselineHits, long baselineInvocations) {
        return RegressionStringUtil.getRegressedEventRate(event, baselineHits, baselineInvocations, false);
    }

    public static String getRegressedEventRate(EventResult event, long baselineHits, long baselineInvocations, boolean fullText) {
        if (baselineInvocations == 0L) {
            return "";
        }
        double rate = (double)baselineHits / (double)baselineInvocations * 100.0;
        StringBuilder result = new StringBuilder();
        result.append(RegressionStringUtil.getEventRate(event, fullText));
        result.append(" from ");
        result.append(decimalFormat.format(rate));
        result.append("%");
        return result.toString();
    }

    public static String getIntroducedBy(EventResult event) {
        return event.introduced_by;
    }

    public static String getRegressionName(RegressionInput input, DateTime activeWindowStart) {
        String result = null;
        if (activeWindowStart != null && input.deployments != null && input.deployments.size() > 0) {
            result = RegressionStringUtil.getRegressionDeploymentName(input, activeWindowStart);
        }
        if (result == null) {
            result = RegressionStringUtil.getRegressionTimeWindowName(input);
        }
        return result;
    }

    public static String getRegressionName(ApiClient apiClient, RegressionInput input, Collection<SummarizedDeployment> summarizedDeployments) {
        String result = null;
        if (input.deployments != null && input.deployments.size() > 0) {
            result = RegressionStringUtil.getRegressionDeploymentName(apiClient, input, summarizedDeployments);
        }
        if (result == null) {
            result = RegressionStringUtil.getRegressionTimeWindowName(input);
        }
        return result;
    }

    private static String getRegressionTimeWindowName(RegressionInput input) {
        DateTime now = DateTime.now();
        DateTime activeWindow = now.minusMinutes(input.activeTimespan);
        DateTime baselineWindow = now.minusMinutes(input.baselineTimespan);
        PrettyTime prettyTime = new PrettyTime();
        String activeWindowDuration = prettyTime.formatDuration(new Date(activeWindow.getMillis()));
        String baselineDuration = prettyTime.formatDuration(new Date(baselineWindow.getMillis()));
        String result = input.activeTimespan > 0 ? String.format(TIME_WINDOW_FORMAT, activeWindowDuration, baselineDuration) : String.format(NOW_WINDOW_FORMAT, baselineDuration);
        return result;
    }

    private static String getRegressionDeploymentName(RegressionInput regressionInput, DateTime activeWindowStart) {
        PrettyTime prettyTime = new PrettyTime();
        String deployment = regressionInput.deployments.size() == 1 ? regressionInput.deployments.iterator().next() : Arrays.toString(regressionInput.deployments.toArray());
        DateTime baseline = DateTime.now().minusMinutes(regressionInput.baselineTimespan);
        String baselineDuration = prettyTime.formatDuration(new Date(baseline.getMillis()));
        String depFirstSeen = prettyTime.format(new Date(activeWindowStart.getMillis()));
        String result = String.format(DEPLOYMENT_FORMAT, deployment, depFirstSeen, baselineDuration);
        return result;
    }

    private static String getRegressionDeploymentName(ApiClient apiClient, RegressionInput regressionInput, Collection<SummarizedDeployment> summarizedDeployment) {
        RegressionUtil.RegressionWindow regressionWindow = RegressionUtil.getActiveWindow(apiClient, regressionInput, summarizedDeployment, System.out);
        return RegressionStringUtil.getRegressionDeploymentName(regressionInput, regressionWindow.activeWindowStart);
    }
}

