/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.regression;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.deployment.SummarizedDeployment;
import com.takipi.api.client.data.event.BaseStats;
import com.takipi.api.client.data.metrics.Graph;
import com.takipi.api.client.request.ViewTimeframeRequest;
import com.takipi.api.client.request.event.EventsVolumeRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.client.result.metrics.GraphResult;
import com.takipi.api.client.util.client.ClientUtil;
import com.takipi.api.client.util.regression.RateRegression;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionStats;
import com.takipi.api.client.util.regression.SeasonlityResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.client.util.view.ViewUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.MathUtil;
import com.takipi.common.util.Pair;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class RegressionUtil {
    public static final int POINT_FACTOR = 60;
    private static final int MAX_BASELINE_POINTS = 100;
    private static final double MAJOR_SPIKE_FACTOR = 0.7;
    private static final double MINOR_SPIKE_FACTOR = 0.35;
    private static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();
    private static final DecimalFormat df = new DecimalFormat("#.000");

    private static boolean hasOlderRelatedEvents(EventResult event, PrintStream printStream, boolean verbose) {
        int eventId;
        if (CollectionUtil.safeIsEmpty((Collection)event.similar_event_ids)) {
            return false;
        }
        try {
            eventId = Integer.parseInt(event.id);
        }
        catch (Exception e) {
            return false;
        }
        for (String similarId : event.similar_event_ids) {
            int similarEventId;
            try {
                similarEventId = Integer.parseInt(similarId);
            }
            catch (Exception e) {
                continue;
            }
            if (eventId <= similarEventId) continue;
            if (verbose && printStream != null) {
                printStream.println("New event " + event.toString() + " has older similar event with ID " + similarId);
            }
            return true;
        }
        return false;
    }

    private static String printEvent(EventResult event) {
        StringBuilder result = new StringBuilder();
        result.append("Event ");
        result.append(event.id);
        result.append(" ");
        result.append(event.summary);
        if (!event.summary.contains("in")) {
            result.append(" in ");
            String[] parts = event.error_location.class_name.split(Pattern.quote("."));
            if (parts.length <= 1) {
                result.append(event.error_location.class_name);
            } else {
                result.append(parts[parts.length - 1]);
            }
            result.append(".");
            result.append(event.error_location.method_name);
        }
        if (!CollectionUtil.safeIsEmpty((Collection)event.similar_event_ids)) {
            result.append("(");
            result.append(String.join((CharSequence)",", event.similar_event_ids));
            result.append(")");
        }
        return result.toString();
    }

    private static String f(double d) {
        if (d % 1.0 == 0.0) {
            return String.valueOf((int)d);
        }
        String result = df.format(d);
        if (result.startsWith(".")) {
            return "0" + result;
        }
        return result;
    }

    private static Map<String, long[]> getPeriodVolumes(DateTime startTime, Graph baselineGraph, int activeTimespan, int baselineTimespan) {
        HashMap<String, long[]> result = new HashMap<String, long[]>();
        DateTime baselineStart = startTime.minusMinutes(baselineTimespan);
        int timeWindows = baselineTimespan / activeTimespan;
        for (Graph.GraphPoint graphPoint : baselineGraph.points) {
            DateTime firstSeen = dateTimeFormatter.parseDateTime(graphPoint.time);
            if (firstSeen.isBefore((ReadableInstant)baselineStart)) continue;
            Minutes timeDelta = Minutes.minutesBetween((ReadableInstant)baselineStart, (ReadableInstant)firstSeen);
            if (graphPoint.contributors == null) continue;
            for (Graph.GraphPointContributor gpc : graphPoint.contributors) {
                int index;
                long[] timeWindowVolumes = (long[])result.get(gpc.id);
                if (timeWindowVolumes == null) {
                    timeWindowVolumes = new long[timeWindows];
                    result.put(gpc.id, timeWindowVolumes);
                }
                int minutes = timeDelta.getMinutes();
                int n = index = Math.min(minutes / activeTimespan, timeWindowVolumes.length - 1);
                timeWindowVolumes[n] = timeWindowVolumes[n] + gpc.stats.hits;
            }
        }
        return result;
    }

    private static String ps(BaseStats stats) {
        if (stats == null) {
            return "(null)";
        }
        return "(" + stats.hits + "/" + stats.invocations + ")";
    }

    private static RegressionState processNewsIssueRegression(EventResult activeEvent, DateTime activeFrom, RegressionInput input, RateRegression.Builder rateRegression, PrintStream printStream, boolean verbose) {
        double activeEventRatio;
        boolean rateExceeded;
        boolean volumeExceeeded;
        boolean isNew;
        DateTime firstSeen = dateTimeFormatter.parseDateTime(activeEvent.first_seen);
        boolean isEventNew = firstSeen.isAfter((ReadableInstant)activeFrom);
        boolean hasOlderSmiliarEvent = RegressionUtil.hasOlderRelatedEvents(activeEvent, printStream, verbose);
        boolean isFromDep = input.deployments == null || input.deployments.size() == 0 || input.deployments.contains(activeEvent.introduced_by);
        boolean bl = isNew = isEventNew && !hasOlderSmiliarEvent && isFromDep;
        if (isNew) {
            boolean isCriticalEventType;
            rateRegression.addNewEvent(activeEvent.id, activeEvent);
            boolean isUncaught = activeEvent.type.equals("Uncaught Exception");
            boolean bl2 = isCriticalEventType = input.criticalExceptionTypes != null && input.criticalExceptionTypes.contains(activeEvent.name);
            if (isUncaught || isCriticalEventType) {
                rateRegression.addCriticalNewEvent(activeEvent.id, activeEvent);
                if (printStream != null) {
                    printStream.println(RegressionUtil.printEvent(activeEvent) + " is critical new event with " + activeEvent.stats.hits);
                }
                return RegressionState.YES;
            }
        }
        if (activeEvent.stats == null || activeEvent.stats.hits == 0L) {
            if (verbose && printStream != null) {
                printStream.println("No stats " + RegressionUtil.ps((BaseStats)activeEvent.stats) + RegressionUtil.printEvent(activeEvent));
            }
            rateRegression.addNonRegressions(activeEvent);
            return RegressionState.NO_DATA;
        }
        double minVolumeThreshold = input.getEventMinThreshold(activeEvent);
        boolean bl3 = volumeExceeeded = minVolumeThreshold > 0.0 && (double)activeEvent.stats.hits > minVolumeThreshold;
        if (activeEvent.stats.invocations == 0L) {
            if (verbose && printStream != null) {
                printStream.println("No inv " + RegressionUtil.ps((BaseStats)activeEvent.stats) + RegressionUtil.printEvent(activeEvent));
            }
            rateExceeded = true;
            activeEventRatio = 0.0;
        } else {
            activeEventRatio = (double)activeEvent.stats.hits / (double)activeEvent.stats.invocations;
            double minErrorRateThreshold = input.getEventMinErrorRateThreshold(activeEvent);
            boolean bl4 = rateExceeded = minErrorRateThreshold > 0.0 && activeEventRatio > minErrorRateThreshold;
        }
        if (!volumeExceeeded || !rateExceeded) {
            if (verbose && printStream != null) {
                printStream.println("Min threshold " + RegressionUtil.ps((BaseStats)activeEvent.stats) + RegressionUtil.printEvent(activeEvent) + "fails hits" + activeEvent.stats.hits + "ratio: " + activeEventRatio);
            }
            if (!volumeExceeeded) {
                rateRegression.addNonRegressions(activeEvent);
                return RegressionState.NO_DATA;
            }
            return RegressionState.NO;
        }
        if (isNew) {
            rateRegression.addExceededNewEvent(activeEvent.id, activeEvent);
            if (printStream != null) {
                printStream.println(RegressionUtil.printEvent(activeEvent) + " is new with ER: " + activeEventRatio + " hits: " + activeEvent.stats.hits);
            }
            return RegressionState.YES;
        }
        return RegressionState.NO;
    }

    private static SeasonlityResult calculateSeasonality(EventResult activeEvent, Map<String, long[]> periodVolumes) {
        long[] eventPeriodVolumes = periodVolumes.get(activeEvent.id);
        long largerVolumePeriod = -1L;
        int largerVolumePriodIndex = -1;
        long halfVolumePeriods = 0L;
        if (eventPeriodVolumes != null) {
            for (int index = 0; index < eventPeriodVolumes.length; ++index) {
                long periodVolume = eventPeriodVolumes[index];
                if ((double)periodVolume > (double)activeEvent.stats.hits * 0.7) {
                    largerVolumePriodIndex = index;
                    largerVolumePeriod = periodVolume;
                    break;
                }
                if (!((double)periodVolume > (double)activeEvent.stats.hits * 0.35)) continue;
                ++halfVolumePeriods;
            }
        }
        return new SeasonlityResult(largerVolumePeriod, halfVolumePeriods, largerVolumePriodIndex);
    }

    private static boolean processVolumeRegression(EventResult activeEvent, RegressionInput input, Map<String, RegressionStats> regressionsStats, Map<String, long[]> periodVolumes, int activeTimespan, RateRegression.Builder rateRegression, PrintStream printStream, boolean verbose) {
        double invRateDelta;
        double normalizedBaselineInv;
        double normalizedActiveInv;
        boolean isCriticalRegression;
        boolean isRegression;
        if (input.regressionDelta == 0.0) {
            return false;
        }
        RegressionStats regressionStats = regressionsStats.get(activeEvent.id);
        if (regressionStats == null) {
            if (verbose && printStream != null) {
                printStream.println("No regression stats " + RegressionUtil.printEvent(activeEvent));
            }
            rateRegression.addNonRegressions(activeEvent);
            return false;
        }
        if (activeEvent.stats.hits == 0L) {
            if (verbose && printStream != null) {
                printStream.println("No active hit stats " + RegressionUtil.printEvent(activeEvent));
            }
            return false;
        }
        if (regressionStats.hits == 0L) {
            if (verbose && printStream != null) {
                printStream.println("No baseline hit stats " + RegressionUtil.printEvent(activeEvent));
            }
            rateRegression.addNonRegressions(activeEvent);
            return false;
        }
        double eventRegressionDelta = input.getEventRegressionDelta(activeEvent);
        double eventCriticalRegressionDelta = input.getEventCriticalRegressionDelta(activeEvent);
        double normalizedBaselineVolume = (double)regressionStats.hits / (double)input.baselineTimespan;
        double normalizedActiveVolume = (double)activeEvent.stats.hits / (double)activeTimespan;
        double volRateDelta = normalizedActiveVolume / normalizedBaselineVolume - 1.0;
        if (activeEvent.stats.invocations == 0L || regressionStats.invocations == 0L) {
            if (verbose && printStream != null) {
                printStream.println("No invocations avail, defaulting to hits calc " + RegressionUtil.printEvent(activeEvent));
            }
            boolean bl = isRegression = volRateDelta > eventRegressionDelta;
            isCriticalRegression = eventCriticalRegressionDelta > 0.0 ? volRateDelta > eventCriticalRegressionDelta : false;
            normalizedActiveInv = 0.0;
            normalizedBaselineInv = 0.0;
            invRateDelta = 0.0;
        } else {
            normalizedActiveInv = (double)activeEvent.stats.invocations / (double)activeTimespan;
            normalizedBaselineInv = (double)regressionStats.invocations / (double)input.baselineTimespan;
            invRateDelta = normalizedActiveInv / normalizedBaselineInv - 1.0;
            boolean bl = isRegression = volRateDelta - Math.max(invRateDelta * 2.0, 0.0) > eventRegressionDelta;
            isCriticalRegression = eventCriticalRegressionDelta > 0.0 ? volRateDelta - Math.max(invRateDelta * 2.0, 0.0) > eventCriticalRegressionDelta : false;
        }
        if (!isRegression) {
            if (verbose && printStream != null) {
                printStream.println("Not regressed " + RegressionUtil.printEvent(activeEvent));
            }
            rateRegression.addNonRegressions(activeEvent);
            return false;
        }
        if (printStream != null) {
            printStream.println(RegressionUtil.printEvent(activeEvent) + " regression\nRelHit: " + RegressionUtil.f(normalizedBaselineVolume) + " -> " + RegressionUtil.f(normalizedActiveVolume) + "\nRelInv: " + RegressionUtil.f(normalizedBaselineInv) + " -> " + RegressionUtil.f(normalizedActiveInv) + "\nVolDel: " + RegressionUtil.f(volRateDelta) + ", InvDel " + RegressionUtil.f(invRateDelta) + "\nhits: " + RegressionUtil.f(regressionStats.hits) + " -> " + RegressionUtil.f(activeEvent.stats.hits) + "\ninv: " + RegressionUtil.f(regressionStats.invocations) + " -> " + RegressionUtil.f(activeEvent.stats.invocations));
        }
        if (input.applySeasonality) {
            SeasonlityResult seasonlityResult = RegressionUtil.calculateSeasonality(activeEvent, periodVolumes);
            if (seasonlityResult.majorSpike >= 0L) {
                if (printStream != null) {
                    printStream.println("Period " + seasonlityResult.makorSpikeIndex + " = " + seasonlityResult.majorSpike + " > active volume. Aborting regression\n");
                }
                rateRegression.addNonRegressions(activeEvent);
                return false;
            }
            if (seasonlityResult.minorSpikes >= 2L) {
                if (printStream != null) {
                    printStream.println(seasonlityResult.minorSpikes + " periods > 50% active volume detected. Aborting regression\n");
                }
                rateRegression.addNonRegressions(activeEvent);
                return false;
            }
        }
        rateRegression.addRegression(activeEvent.id, activeEvent, regressionStats.hits, regressionStats.invocations);
        if (isCriticalRegression && input.criticalRegressionDelta > 0.0) {
            rateRegression.addCriticalRegression(activeEvent.id, activeEvent, regressionStats.hits, regressionStats.invocations);
        }
        if (printStream != null) {
            printStream.println("\n");
        }
        return true;
    }

    private static void ApplyFilter(ViewTimeframeRequest.Builder builder, RegressionInput input, boolean applyDeps, boolean applyApps) {
        if (applyApps && input.applictations != null) {
            for (String app : input.applictations) {
                if (app.isEmpty()) continue;
                builder.addApp(app);
            }
        }
        if (applyDeps && input.deployments != null) {
            for (String dep : input.deployments) {
                if (dep.isEmpty()) continue;
                builder.addDeployment(dep);
            }
        }
        if (input.servers != null) {
            for (String srv : input.servers) {
                if (srv.isEmpty()) continue;
                builder.addServer(srv);
            }
        }
    }

    public static EventsResult getEventsVolume(ApiClient apiClient, RegressionInput input, DateTime from, DateTime to) {
        return RegressionUtil.getEventsVolume(apiClient, input, from, to, false);
    }

    public static EventsResult getEventsVolume(ApiClient apiClient, RegressionInput input, DateTime from, DateTime to, boolean ignoreAppsFilter) {
        String fromStr = from.toString(ISODateTimeFormat.dateTime().withZoneUTC());
        String toStr = to.toString(ISODateTimeFormat.dateTime().withZoneUTC());
        EventsVolumeRequest.Builder builder = EventsVolumeRequest.newBuilder().setServiceId(input.serviceId).setViewId(input.viewId).setFrom(fromStr).setTo(toStr).setVolumeType(ValidationUtil.VolumeType.all);
        RegressionUtil.ApplyFilter((ViewTimeframeRequest.Builder)builder, input, true, !ignoreAppsFilter);
        UrlClient.Response response = apiClient.get((ApiGetRequest)builder.build());
        if (response.isBadResponse()) {
            throw new IllegalStateException("Error querying volume data with code " + response.responseCode);
        }
        EventsResult result = (EventsResult)response.data;
        return result;
    }

    private static Graph validateGraph(ApiClient apiClient, GraphResult graphResult, RegressionInput input, PrintStream printStream) {
        if (CollectionUtil.safeIsEmpty((Collection)graphResult.graphs)) {
            if (printStream != null) {
                printStream.println("Empty graph result from " + apiClient.getHostname() + " for " + input.toString());
            }
            return null;
        }
        Graph graph = (Graph)graphResult.graphs.get(0);
        if (!input.viewId.equals(graph.id)) {
            if (printStream != null) {
                printStream.println("Graph Id mismatch recevied " + graph.id + " from " + apiClient.getHostname() + " for " + input.toString());
            }
            return null;
        }
        if (CollectionUtil.safeIsEmpty((Collection)graph.points)) {
            if (printStream != null) {
                printStream.println("Empty graph points from " + apiClient.getHostname() + " for " + input.toString());
            }
            return null;
        }
        return graph;
    }

    private static boolean validateVolume(ApiClient apiClient, EventsResult eventResult, RegressionInput input, PrintStream printStream) {
        if (CollectionUtil.safeIsEmpty((Collection)eventResult.events)) {
            if (printStream != null) {
                printStream.println("Empty event volume result from " + apiClient.getHostname() + " for " + input.toString());
            }
            return false;
        }
        return true;
    }

    public static Pair<DateTime, DateTime> getDeploymentsActiveWindow(ApiClient apiClient, String serviceId) {
        Collection<SummarizedDeployment> activeSummarizedDeployments = ClientUtil.getSummarizedDeployments(apiClient, serviceId, false);
        return RegressionUtil.getDeploymentsActiveWindow(activeSummarizedDeployments);
    }

    public static Pair<DateTime, DateTime> getDeploymentsActiveWindow(ApiClient apiClient, String serviceId, Collection<String> deployments) {
        Collection<SummarizedDeployment> activeSummarizedDeployments = ClientUtil.getSummarizedDeployments(apiClient, serviceId, false);
        return RegressionUtil.getDeploymentsActiveWindow(deployments, activeSummarizedDeployments);
    }

    private static Pair<DateTime, DateTime> getDeploymentsActiveWindow(Collection<SummarizedDeployment> summarizedDeployments) {
        DateTime minDeploymentStart = null;
        DateTime maxDeploymentEnd = new DateTime(0L);
        for (SummarizedDeployment summarizedDeployment : summarizedDeployments) {
            if (summarizedDeployment == null || summarizedDeployment.first_seen == null) {
                return null;
            }
            DateTime start = dateTimeFormatter.parseDateTime(summarizedDeployment.first_seen);
            DateTime end = null;
            if (summarizedDeployment.last_seen != null) {
                end = dateTimeFormatter.parseDateTime(summarizedDeployment.last_seen);
            }
            if (minDeploymentStart == null || start.isBefore((ReadableInstant)minDeploymentStart)) {
                minDeploymentStart = start;
            }
            if (end != null && !end.isAfter((ReadableInstant)maxDeploymentEnd)) continue;
            maxDeploymentEnd = end;
        }
        Pair deploymentsActiveWindow = Pair.of(minDeploymentStart, (Object)maxDeploymentEnd);
        return deploymentsActiveWindow;
    }

    private static Pair<DateTime, DateTime> getDeploymentsActiveWindow(Collection<String> deployments, Collection<SummarizedDeployment> summarizedDeployments) {
        HashMap<String, SummarizedDeployment> summarizedDeploymentByName = new HashMap<String, SummarizedDeployment>();
        for (SummarizedDeployment summaryDeployment : summarizedDeployments) {
            summarizedDeploymentByName.put(summaryDeployment.name, summaryDeployment);
        }
        DateTime minDeploymentStart = null;
        DateTime maxDeploymentEnd = new DateTime(0L);
        for (String deployment : deployments) {
            SummarizedDeployment summarizedDeployment = (SummarizedDeployment)summarizedDeploymentByName.get(deployment);
            if (summarizedDeployment == null || summarizedDeployment.first_seen == null) {
                return null;
            }
            DateTime start = dateTimeFormatter.parseDateTime(summarizedDeployment.first_seen);
            DateTime end = null;
            if (summarizedDeployment.last_seen != null) {
                end = dateTimeFormatter.parseDateTime(summarizedDeployment.last_seen);
            }
            if (minDeploymentStart == null || start.isBefore((ReadableInstant)minDeploymentStart)) {
                minDeploymentStart = start;
            }
            if (end != null && !end.isAfter((ReadableInstant)maxDeploymentEnd)) continue;
            maxDeploymentEnd = end;
        }
        Pair deploymentsActiveWindow = Pair.of(minDeploymentStart, (Object)maxDeploymentEnd);
        return deploymentsActiveWindow;
    }

    public static RegressionWindow getActiveWindow(ApiClient apiClient, RegressionInput input, Collection<SummarizedDeployment> summarizedDeployments, PrintStream printStream) {
        RegressionWindow result = new RegressionWindow();
        result.activeTimespan = input.activeTimespan;
        if (input.activeWindowStart != null) {
            result.activeWindowStart = input.activeWindowStart;
            return result;
        }
        DateTime now = DateTime.now();
        if (CollectionUtil.safeIsEmpty(input.deployments)) {
            result.activeWindowStart = now.minusMinutes(input.activeTimespan);
            return result;
        }
        Pair<DateTime, DateTime> deploymentsActiveWindow = CollectionUtil.safeIsEmpty(summarizedDeployments) ? RegressionUtil.getDeploymentsActiveWindow(apiClient, input.serviceId, input.deployments) : RegressionUtil.getDeploymentsActiveWindow(input.deployments, summarizedDeployments);
        if (deploymentsActiveWindow == null) {
            result.activeWindowStart = now.minusMinutes(input.activeTimespan);
            result.deploymentNotFound = true;
            return result;
        }
        result.activeWindowStart = (DateTime)deploymentsActiveWindow.getFirst();
        if (result.activeWindowStart == null) {
            result.deploymentNotFound = true;
            if (printStream != null) {
                printStream.println("Could not acquire start time for deployments " + Arrays.toString(input.deployments.toArray()));
            }
            return result;
        }
        DateTime activeWindowEnd = deploymentsActiveWindow.getSecond() != null ? (DateTime)deploymentsActiveWindow.getSecond() : now;
        result.activeTimespan = (int)TimeUnit.MILLISECONDS.toMinutes(activeWindowEnd.minus(result.activeWindowStart.getMillis()).getMillis());
        if (result.activeTimespan <= 0) {
            result.activeTimespan = (int)TimeUnit.DAYS.toMinutes(1L);
            result.activeWindowStart = now.minusDays(1);
        }
        return result;
    }

    private static Graph getBaselineGraph(ApiClient apiClient, RegressionInput input, DateTime baselineStart, DateTime activeWindowStart, int activeTimespan, PrintStream printStream) {
        Graph result = null;
        if (input.baselineGraph != null) {
            result = input.baselineGraph;
        } else {
            GraphResult graphResult;
            int pointsWanted = Math.min(input.baselineTimespan / activeTimespan * 2, 100);
            if (pointsWanted > 0 && (graphResult = ViewUtil.getEventsGraphResult(apiClient, input.serviceId, input.viewId, pointsWanted, ValidationUtil.VolumeType.all, baselineStart, activeWindowStart, true, true, true, true)) != null) {
                result = RegressionUtil.validateGraph(apiClient, graphResult, input, printStream);
            }
        }
        return result;
    }

    public static Collection<EventResult> getActiveEventVolume(ApiClient apiClient, RegressionInput input, DateTime activeWindowStart, PrintStream printStream) {
        return RegressionUtil.getActiveEventVolume(apiClient, input, activeWindowStart, printStream, false);
    }

    public static Collection<EventResult> getActiveEventVolume(ApiClient apiClient, RegressionInput input, DateTime activeWindowStart, PrintStream printStream, boolean ignoreAppsFilter) {
        List result;
        if (input.events != null) {
            result = input.events;
        } else {
            EventsResult activeEventVolume = RegressionUtil.getEventsVolume(apiClient, input, activeWindowStart, DateTime.now(), ignoreAppsFilter);
            if (!RegressionUtil.validateVolume(apiClient, activeEventVolume, input, printStream)) {
                return null;
            }
            result = activeEventVolume.events;
        }
        return result;
    }

    public static RateRegression calculateRateRegressions(ApiClient apiClient, RegressionInput input, PrintStream printStream, boolean verbose) {
        RegressionWindow regressionWindow = RegressionUtil.getActiveWindow(apiClient, input, Collections.emptyList(), printStream);
        RateRegression result = RegressionUtil.calculateRateRegressions(apiClient, input, regressionWindow, printStream, verbose);
        return result;
    }

    public static RateRegression calculateRateRegressions(ApiClient apiClient, RegressionInput input, RegressionWindow regressionWindow, PrintStream printStream, boolean verbose) {
        Map<String, long[]> periodVolumes;
        Map<String, RegressionStats> regressionsStats;
        Graph baselineGraph;
        boolean hasRegressionDeltas;
        Collection<EventResult> events;
        if (printStream != null) {
            printStream.println("Begin regression analysis");
        }
        RateRegression.Builder builder = new RateRegression.Builder();
        if (regressionWindow.activeTimespan == 0 && regressionWindow.deploymentNotFound) {
            if (printStream != null) {
                printStream.println("No active timespan set and no deployment volume found in baseline - skipping analysis");
            }
            return builder.build();
        }
        builder.setActiveWindowStart(regressionWindow.activeWindowStart);
        DateTime baselineStart = regressionWindow.activeWindowStart.minusMinutes(input.baselineTimespan);
        if (printStream != null) {
            printStream.println("Regression Active window starts at: " + regressionWindow.activeWindowStart);
            printStream.println("Regression Baseline window starts at: " + baselineStart);
        }
        if ((events = RegressionUtil.getActiveEventVolume(apiClient, input, regressionWindow.activeWindowStart, printStream)) == null) {
            return builder.build();
        }
        boolean bl = hasRegressionDeltas = input.regressionDelta > 0.0 || input.criticalRegressionDelta > 0.0;
        if (!hasRegressionDeltas && printStream != null) {
            printStream.println("No regression deltas set for input. Regressions will not be calcualated.");
        }
        if (hasRegressionDeltas) {
            baselineGraph = RegressionUtil.getBaselineGraph(apiClient, input, baselineStart, regressionWindow.activeWindowStart, regressionWindow.activeTimespan, printStream);
            if (baselineGraph != null) {
                regressionsStats = RegressionUtil.processEventsGraph(baselineGraph);
                periodVolumes = RegressionUtil.getPeriodVolumes(regressionWindow.activeWindowStart, baselineGraph, regressionWindow.activeTimespan, input.baselineTimespan);
            } else {
                regressionsStats = null;
                periodVolumes = null;
            }
        } else {
            regressionsStats = null;
            periodVolumes = null;
            baselineGraph = null;
        }
        for (EventResult activeEvent : events) {
            if (activeEvent.error_location == null) {
                if (printStream == null) continue;
                printStream.println("Event has no location: " + activeEvent.summary);
                continue;
            }
            RegressionState newState = RegressionUtil.processNewsIssueRegression(activeEvent, regressionWindow.activeWindowStart, input, builder, printStream, verbose);
            if (newState == RegressionState.YES || newState == RegressionState.NO_DATA) continue;
            if (baselineGraph != null && regressionsStats != null && periodVolumes != null) {
                RegressionUtil.processVolumeRegression(activeEvent, input, regressionsStats, periodVolumes, regressionWindow.activeTimespan, builder, printStream, verbose);
                continue;
            }
            builder.addNonRegressions(activeEvent);
        }
        RateRegression result = builder.build();
        if (verbose) {
            RegressionUtil.printNonRegressions(result, printStream);
        }
        return result;
    }

    private static void printNonRegressions(RateRegression rateRegression, PrintStream printStream) {
        if (printStream != null) {
            ArrayList<EventResult> nonRegressions = new ArrayList<EventResult>(rateRegression.getNonRegressions());
            nonRegressions.sort(new Comparator<EventResult>(){

                @Override
                public int compare(EventResult o1, EventResult o2) {
                    return (int)o1.stats.hits - (int)o2.stats.hits;
                }
            });
            printStream.println("\nNon regressions:\n");
            for (EventResult event : nonRegressions) {
                printStream.println(event.stats.hits + " " + RegressionUtil.printEvent(event));
            }
        }
    }

    private static Map<String, RegressionStats> processEventsGraph(Graph graph) {
        HashMap<String, Pair> rawData = new HashMap<String, Pair>();
        int pointsCount = graph.points.size();
        for (int i = 0; i < pointsCount; ++i) {
            Graph.GraphPoint currentPoint = (Graph.GraphPoint)graph.points.get(i);
            if (CollectionUtil.safeIsEmpty((Collection)currentPoint.contributors)) continue;
            for (Graph.GraphPointContributor contributor : currentPoint.contributors) {
                if (contributor.stats == null) continue;
                Pair eventData = (Pair)rawData.get(contributor.id);
                if (eventData == null) {
                    eventData = Pair.of((Object)new long[pointsCount], (Object)new long[pointsCount]);
                    rawData.put(contributor.id, eventData);
                }
                ((long[])eventData.getFirst())[i] = contributor.stats.hits;
                ((long[])eventData.getSecond())[i] = contributor.stats.invocations;
            }
        }
        HashMap<String, RegressionStats> result = new HashMap<String, RegressionStats>(rawData.size());
        for (Map.Entry entry : rawData.entrySet()) {
            result.put((String)entry.getKey(), RegressionUtil.buildRegressionStats((Pair<long[], long[]>)((Pair)entry.getValue())));
        }
        return result;
    }

    private static RegressionStats buildRegressionStats(Pair<long[], long[]> eventStats) {
        long[] hitsArr = (long[])eventStats.getFirst();
        long[] invocationsArr = (long[])eventStats.getSecond();
        double[] rateArr = RegressionUtil.getRateArr(hitsArr, invocationsArr);
        long hitsSum = MathUtil.sum(hitsArr);
        long invocationsSum = MathUtil.sum(invocationsArr);
        double overallRate = invocationsSum == 0L ? 0.0 : (double)hitsSum / (double)invocationsSum;
        double hitsAvg = MathUtil.avg(hitsArr);
        double invocationsAvg = MathUtil.avg(invocationsArr);
        double rateAvg = MathUtil.avg(rateArr);
        double hitsAvgStdDev = MathUtil.stdDev(hitsArr);
        double invocationsAvgStdDev = MathUtil.stdDev(invocationsArr);
        double rateAvgStdDev = MathUtil.stdDev(rateArr);
        return RegressionStats.of(hitsSum, invocationsSum, overallRate, hitsAvg, invocationsAvg, rateAvg, hitsAvgStdDev, invocationsAvgStdDev, rateAvgStdDev);
    }

    public static double[] getRateArr(long[] hits, long[] invocations) {
        double[] result = new double[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            long curHits = hits[i];
            long curInvocations = invocations[i];
            result[i] = curInvocations == 0L ? 0.0 : (double)curHits / (double)curInvocations;
        }
        return result;
    }

    static enum RegressionState {
        YES,
        NO,
        NO_DATA;

    }

    public static class RegressionWindow {
        public DateTime activeWindowStart;
        public int activeTimespan;
        public boolean deploymentNotFound;

        public RegressionWindow clone() {
            RegressionWindow result = new RegressionWindow();
            result.activeWindowStart = this.activeWindowStart;
            result.activeTimespan = this.activeTimespan;
            result.deploymentNotFound = this.deploymentNotFound;
            return result;
        }
    }
}

