/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.settings;

import com.takipi.api.client.util.settings.ServiceSettingsData;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class GroupSettings {
    public static final String REGEX_ESCAPE = "/";
    public static final String CATEGORY_PREFIX = "-";
    public List<Group> groups;

    public Collection<Group> getGroups() {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        return this.groups;
    }

    public static String fromGroupName(String value) {
        if (value == null || !GroupSettings.isGroup(value)) {
            return value;
        }
        return value.substring(CATEGORY_PREFIX.length());
    }

    public static String toGroupName(String value) {
        if (!GroupSettings.isGroup(value)) {
            return CATEGORY_PREFIX + value;
        }
        return value;
    }

    public static boolean isGroup(String name) {
        return name.startsWith(CATEGORY_PREFIX);
    }

    public GroupFilter getExpandedFilter(Collection<String> values) {
        return GroupFilter.from(this.expandList(values));
    }

    public Collection<String> expandList(Collection<String> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values) {
            if (GroupSettings.isGroup(value)) {
                result.addAll(this.getGroupValues(value));
                continue;
            }
            result.add(value);
        }
        return result;
    }

    public GroupFilter getAllGroupFilter() {
        return GroupFilter.from(this.expandList(this.getAllGroupValues()));
    }

    public Collection<String> getAllGroupNames(boolean includePrefix) {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Group group : this.groups) {
            if (includePrefix) {
                result.add(GroupSettings.toGroupName(group.name));
                continue;
            }
            result.add(group.name);
        }
        return result;
    }

    public Collection<String> getAllGroupValues() {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Group group : this.groups) {
            result.addAll(group.getValues());
        }
        return result;
    }

    public Group getGroup(String groupName) {
        if (this.groups == null) {
            return null;
        }
        int index = groupName.indexOf(CATEGORY_PREFIX);
        String value = index >= 0 ? groupName.substring(index + 1) : groupName;
        for (Group group : this.groups) {
            if (!ObjectUtil.equal((Object)group.name, (Object)value)) continue;
            return group;
        }
        return null;
    }

    public Collection<String> getGroupValues(String groupName) {
        Group group = this.getGroup(groupName);
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getValues();
    }

    public static class Group {
        public String name;
        public List<String> values;

        public GroupFilter getFilter() {
            return GroupFilter.from(this.getValues());
        }

        public Collection<String> getValues() {
            if (CollectionUtil.safeIsEmpty(this.values)) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String value : this.values) {
                result.addAll(Arrays.asList(value.split(ServiceSettingsData.ARRAY_SEPERATOR)));
            }
            return result;
        }

        public String toGroupName() {
            if (!GroupSettings.isGroup(this.name)) {
                return GroupSettings.toGroupName(this.name);
            }
            return this.name;
        }
    }

    public static class GroupFilter {
        public final Collection<String> values;
        public final Collection<Pattern> patterns;

        private GroupFilter(Collection<String> values, Collection<Pattern> patterns) {
            this.values = new ArrayList<String>(values);
            this.patterns = new ArrayList<Pattern>(patterns);
        }

        public boolean isEmpty() {
            return CollectionUtil.safeIsEmpty(this.values) && CollectionUtil.safeIsEmpty(this.patterns);
        }

        public boolean filter(String s) {
            for (String value : this.values) {
                if (!s.contains(value)) continue;
                return false;
            }
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(s).find()) continue;
                return false;
            }
            return true;
        }

        public static GroupFilter from(Collection<String> values) {
            ArrayList<String> filterValues = new ArrayList<String>();
            ArrayList<Pattern> filterPatterns = new ArrayList<Pattern>();
            for (String value : values) {
                if (GroupFilter.isRegexValue(value)) {
                    String regex = value.substring(1, value.length() - 1);
                    filterPatterns.add(Pattern.compile(regex));
                    continue;
                }
                filterValues.add(value);
            }
            return GroupFilter.from(filterValues, filterPatterns);
        }

        public static GroupFilter from(Collection<String> values, Collection<Pattern> patterns) {
            return new GroupFilter(values, patterns);
        }

        private static boolean isRegexValue(String value) {
            return value.length() > 2 && value.startsWith(GroupSettings.REGEX_ESCAPE) && value.endsWith(GroupSettings.REGEX_ESCAPE);
        }
    }
}

