/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.settings;

import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.request.reliability.GetReliabilitySettingsRequest;
import com.takipi.api.client.result.reliability.GetReliabilitySettingsResult;
import com.takipi.api.client.util.settings.ServiceSettingsData;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsUtil {
    private static final Logger logger = LoggerFactory.getLogger(SettingsUtil.class);

    public static ServiceSettingsData getServiceReliabilitySettings(ApiClient apiClient, String serviceId) {
        GetReliabilitySettingsRequest request = GetReliabilitySettingsRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response response = apiClient.get((ApiGetRequest)request);
        if (response.isBadResponse() || response.data == null || StringUtil.isNullOrEmpty((String)((GetReliabilitySettingsResult)response.data).reliability_settings_json)) {
            logger.warn("Failed getting reliability settings for {}.", (Object)serviceId);
            return null;
        }
        try {
            return (ServiceSettingsData)new Gson().fromJson(((GetReliabilitySettingsResult)response.data).reliability_settings_json, ServiceSettingsData.class);
        }
        catch (Exception e) {
            logger.warn("Failed parsing service settings for {}.", (Object)serviceId);
            return null;
        }
    }
}

