/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.view;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.metrics.Graph;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.data.view.ViewFilters;
import com.takipi.api.client.data.view.ViewInfo;
import com.takipi.api.client.request.category.CategoryAddViewRequest;
import com.takipi.api.client.request.event.EventsRequest;
import com.takipi.api.client.request.event.EventsVolumeRequest;
import com.takipi.api.client.request.metrics.GraphRequest;
import com.takipi.api.client.request.view.CreateViewRequest;
import com.takipi.api.client.request.view.DeleteViewRequest;
import com.takipi.api.client.request.view.ViewRequest;
import com.takipi.api.client.request.view.ViewsRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.client.result.metrics.GraphResult;
import com.takipi.api.client.result.view.CreateViewResult;
import com.takipi.api.client.result.view.ViewResult;
import com.takipi.api.client.result.view.ViewsResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiDeleteRequest;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.Pair;
import com.takipi.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ViewUtil {
    private static final DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();

    public static void createFilteredView(ApiClient apiClient, String serviceId, ViewInfo viewInfo, String categoryId) {
        ViewUtil.createFilteredViews(apiClient, serviceId, Collections.singleton(viewInfo), categoryId);
    }

    public static void createFilteredViews(ApiClient apiClient, String serviceId, Collection<ViewInfo> viewInfos, String categoryId) {
        Map<String, SummarizedView> views = ViewUtil.getServiceViewsByName(apiClient, serviceId);
        ViewUtil.createFilteredViews(apiClient, serviceId, viewInfos, views, categoryId);
    }

    public static void createFilteredViews(ApiClient apiClient, String serviceId, Collection<ViewInfo> viewInfos, Map<String, SummarizedView> views, String categoryId) {
        for (ViewInfo viewInfo : viewInfos) {
            ViewUtil.createFilteredView(apiClient, serviceId, viewInfo, categoryId, views);
        }
    }

    private static void createFilteredView(ApiClient apiClient, String serviceId, ViewInfo viewInfo, String categoryId, Map<String, SummarizedView> views) {
        CategoryAddViewRequest categoryAddViewRequest;
        UrlClient.Response categoryAddViewResponse;
        SummarizedView view = views.get(viewInfo.name);
        if (view != null) {
            System.out.println("view " + viewInfo.name + " found with ID " + view.id);
            return;
        }
        CreateViewRequest createViewRequest = CreateViewRequest.newBuilder().setServiceId(serviceId).setViewInfo(viewInfo).build();
        UrlClient.Response viewResponse = apiClient.post((ApiPostRequest)createViewRequest);
        if (viewResponse.isBadResponse() || viewResponse.data == null) {
            System.err.println("Cannot create view " + viewInfo.name);
            return;
        }
        System.out.println("Created view " + ((CreateViewResult)viewResponse.data).view_id + " for view " + viewInfo.name);
        if (categoryId != null && (categoryAddViewResponse = apiClient.post((ApiPostRequest)(categoryAddViewRequest = CategoryAddViewRequest.newBuilder().setServiceId(serviceId).setViewId(((CreateViewResult)viewResponse.data).view_id).setCategoryId(categoryId).build()))).isBadResponse()) {
            System.out.println("Error adding view " + viewInfo.name + " to category " + categoryId);
        }
    }

    public static void createLabelViewsIfNotExists(ApiClient apiClient, String serviceId, Collection<Pair<String, String>> viewsAndLabels, boolean immutableViews, String categoryId) {
        ArrayList<ViewInfo> viewInfos = new ArrayList<ViewInfo>();
        for (Pair<String, String> pair : viewsAndLabels) {
            String viewName = (String)pair.getFirst();
            String labelName = (String)pair.getSecond();
            ViewInfo viewInfo = new ViewInfo();
            viewInfo.name = viewName;
            viewInfo.filters = new ViewFilters();
            viewInfo.filters.labels = Collections.singletonList(labelName);
            viewInfo.shared = true;
            viewInfo.immutable = immutableViews;
            viewInfos.add(viewInfo);
        }
        ViewUtil.createFilteredViews(apiClient, serviceId, viewInfos, categoryId);
    }

    public static Map<String, SummarizedView> getServiceViewsByName(ApiClient apiClient, String serviceId) {
        ViewsRequest viewsRequest = ViewsRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response viewsResponse = apiClient.get((ApiGetRequest)viewsRequest);
        if (viewsResponse.isBadResponse() || viewsResponse.data == null || ((ViewsResult)viewsResponse.data).views == null) {
            System.err.println("Can't list views");
            return Collections.emptyMap();
        }
        HashMap<String, SummarizedView> result = new HashMap<String, SummarizedView>();
        for (SummarizedView view : ((ViewsResult)viewsResponse.data).views) {
            result.put(view.name, view);
        }
        return result;
    }

    public static ViewResult getServiceView(ApiClient apiClient, String serviceId, String viewId) {
        ViewRequest viewRequest = ViewRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).build();
        UrlClient.Response viewsResponse = apiClient.get((ApiGetRequest)viewRequest);
        if (viewsResponse.isBadResponse() || viewsResponse.data == null || StringUtil.isNullOrEmpty((String)((ViewResult)viewsResponse.data).id) || StringUtil.isNullOrEmpty((String)((ViewResult)viewsResponse.data).name)) {
            return null;
        }
        return (ViewResult)viewsResponse.data;
    }

    public static SummarizedView getServiceViewByName(ApiClient apiClient, String serviceId, String viewName) {
        ViewsRequest viewsRequest = ViewsRequest.newBuilder().setServiceId(serviceId).setViewName(viewName).build();
        UrlClient.Response viewsResponse = apiClient.get((ApiGetRequest)viewsRequest);
        if (viewsResponse.isBadResponse() || viewsResponse.data == null || ((ViewsResult)viewsResponse.data).views == null || ((ViewsResult)viewsResponse.data).views.size() == 0) {
            return null;
        }
        SummarizedView result = (SummarizedView)((ViewsResult)viewsResponse.data).views.get(0);
        return result;
    }

    public static EventsResult getEventsVolume(ApiClient apiClient, String serviceId, String viewId, DateTime from, DateTime to) {
        EventsVolumeRequest eventsVolumeRequest = EventsVolumeRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).setFrom(from.toString(fmt)).setTo(to.toString(fmt)).setVolumeType(ValidationUtil.VolumeType.all).build();
        UrlClient.Response eventsVolumeResponse = apiClient.get((ApiGetRequest)eventsVolumeRequest);
        if (eventsVolumeResponse.isBadResponse()) {
            return null;
        }
        EventsResult eventsVolumeResult = (EventsResult)eventsVolumeResponse.data;
        if (eventsVolumeResult == null) {
            return null;
        }
        if (eventsVolumeResult.events == null) {
            return null;
        }
        return eventsVolumeResult;
    }

    public static List<EventResult> getEvents(ApiClient apiClient, String serviceId, String viewId, DateTime from, DateTime to) {
        EventsRequest eventsVolumeRequest = EventsRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).setFrom(from.toString(fmt)).setTo(to.toString(fmt)).build();
        UrlClient.Response eventsResponse = apiClient.get((ApiGetRequest)eventsVolumeRequest);
        if (eventsResponse.isBadResponse()) {
            return null;
        }
        EventsResult eventsResult = (EventsResult)eventsResponse.data;
        if (eventsResult == null) {
            return null;
        }
        if (eventsResult.events == null) {
            return null;
        }
        return eventsResult.events;
    }

    public static Graph getEventsGraph(ApiClient apiClient, String serviceId, String viewId, int pointsCount, ValidationUtil.VolumeType volumeType, DateTime from, DateTime to) {
        GraphResult graphResult = ViewUtil.getEventsGraphResult(apiClient, serviceId, viewId, pointsCount, volumeType, from, to);
        if (CollectionUtil.safeIsEmpty((Collection)graphResult.graphs)) {
            return null;
        }
        Graph graph = (Graph)graphResult.graphs.get(0);
        if (!viewId.equals(graph.id)) {
            return null;
        }
        if (CollectionUtil.safeIsEmpty((Collection)graph.points)) {
            return null;
        }
        return graph;
    }

    public static GraphResult getEventsGraphResult(ApiClient apiClient, String serviceId, String viewId, int pointsCount, ValidationUtil.VolumeType volumeType, DateTime from, DateTime to) {
        return ViewUtil.getEventsGraphResult(apiClient, serviceId, viewId, pointsCount, volumeType, from, to, false, true, true, true);
    }

    public static GraphResult getEventsGraphResult(ApiClient apiClient, String serviceId, String viewId, int pointsCount, ValidationUtil.VolumeType volumeType, DateTime from, DateTime to, boolean raw, boolean breakServers, boolean breakApps, boolean breakDeployments) {
        GraphRequest graphRequest = GraphRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).setGraphType(ValidationUtil.GraphType.view).setFrom(from.toString(fmt)).setTo(to.toString(fmt)).setVolumeType(volumeType).setWantedPointCount(pointsCount).setRaw(raw).setBreakServers(breakServers).setBreakApps(breakApps).setBreakDeployments(breakDeployments).build();
        UrlClient.Response graphResponse = apiClient.get((ApiGetRequest)graphRequest);
        if (graphResponse.isBadResponse()) {
            return null;
        }
        GraphResult graphResult = (GraphResult)graphResponse.data;
        if (graphResult == null) {
            return null;
        }
        return graphResult;
    }

    public static void removeView(ApiClient apiClient, String serviceId, String viewId) {
        DeleteViewRequest viewRequest = DeleteViewRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).build();
        UrlClient.Response viewResponse = apiClient.delete((ApiDeleteRequest)viewRequest);
        if (viewResponse.isBadResponse()) {
            System.err.println("Problem removing view " + viewId);
            return;
        }
        System.out.println("Removed view " + viewId);
    }
}

