/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.common.util;

import com.takipi.common.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.ocpsoft.prettytime.PrettyTime;

public class TimeUtil {
    private static final String LAST_TIME_WINDOW = "time >= now() - ";
    private static final String SO_FAR_WINDOW = "time >= ";
    private static final String RANGE_WINDOW = "and time <= ";
    private static final String MILLI_UNIT = "ms";
    public static final String MINUTE_POSTFIX = "m";
    public static final String HOUR_POSTFIX = "h";
    public static final String DAY_POSTFIX = "d";
    public static final String DEFAULT_TIME_RANGE_STR = "1d";
    private static final DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();
    private static final PrettyTime prettyTime = new PrettyTime();
    public static final DateTime START_OF_TIME = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeZone.UTC);
    public static final DateTime END_OF_TIME = new DateTime(2037, 1, 1, 0, 0, 0, DateTimeZone.UTC);

    public static String getDateTimeFromEpoch(long epoch) {
        return new DateTime(epoch).toString(fmt);
    }

    public static long getDateTimeDelta(DateTime from, DateTime to) {
        return to.getMillis() - from.getMillis();
    }

    public static long getDateTimeDeltaMill(Pair<DateTime, DateTime> timespan) {
        return TimeUtil.getDateTimeDelta((DateTime)timespan.getFirst(), (DateTime)timespan.getSecond());
    }

    public static long getDateTimeDelta(Pair<String, String> timespan) {
        DateTime from = fmt.parseDateTime((String)timespan.getFirst());
        DateTime to = fmt.parseDateTime((String)timespan.getSecond());
        return TimeUtil.getDateTimeDelta(from, to);
    }

    public static String getDateTimeFromEpoch(String epoch) {
        return new DateTime((Object)Long.valueOf(epoch)).toString(fmt);
    }

    public static String getTimeInterval(long timeDelta) {
        String result = timeDelta > TimeUnit.DAYS.toMillis(1L) ? TimeUnit.MILLISECONDS.toDays(timeDelta) + DAY_POSTFIX : (timeDelta > TimeUnit.HOURS.toMillis(1L) ? TimeUnit.MILLISECONDS.toHours(timeDelta) + HOUR_POSTFIX : TimeUnit.MILLISECONDS.toMinutes(timeDelta) + MINUTE_POSTFIX);
        return result;
    }

    public static String getTimeRange(int min) {
        return TimeUtil.getTimeRange(min, false);
    }

    public static String getTimeRange(int min, boolean allowDays) {
        if (allowDays && min % 1440 == 0 && min > (int)TimeUnit.DAYS.toMinutes(3L)) {
            double days = (double)min / 24.0 / 60.0;
            return String.valueOf(Math.round(days)) + DAY_POSTFIX;
        }
        if (min % 60 == 0) {
            double hours = (double)min / 60.0;
            return String.valueOf(Math.round(hours)) + HOUR_POSTFIX;
        }
        return min + MINUTE_POSTFIX;
    }

    public static String getLastWindowMinTimeFilter(int minDelta) {
        return LAST_TIME_WINDOW + TimeUtil.getTimeRange(minDelta);
    }

    public static String getLastWindowTimeFilter(long timeDelta) {
        return LAST_TIME_WINDOW + TimeUtil.getTimeInterval(timeDelta);
    }

    public static int parseInterval(String timeWindowWithUnit) {
        String timeWindow = timeWindowWithUnit.substring(0, timeWindowWithUnit.length() - 1);
        char timeUnit = timeWindowWithUnit.charAt(timeWindowWithUnit.length() - 1);
        int delta = Integer.valueOf(timeWindow);
        if (timeUnit == DAY_POSTFIX.charAt(0)) {
            return delta * 24 * 60;
        }
        if (timeUnit == HOUR_POSTFIX.charAt(0)) {
            return delta * 60;
        }
        if (timeUnit == MINUTE_POSTFIX.charAt(0)) {
            return delta;
        }
        throw new IllegalStateException("Unknown time unit for " + timeWindowWithUnit);
    }

    public static String getMillisAsString(DateTime date) {
        return String.valueOf(date.getMillis());
    }

    public static long getLongTime(String value) {
        return fmt.parseDateTime(value).getMillis();
    }

    public static long getEpoch(String value) {
        if (value == null) {
            return 0L;
        }
        return TimeUtil.getDateTime(value).getMillis();
    }

    public static DateTime getDateTime(String value) {
        if (value == null) {
            return null;
        }
        return fmt.parseDateTime(value);
    }

    public static int getStartDateTimeIndex(List<Pair<DateTime, DateTime>> intervals, String value) {
        DateTime dateTime = TimeUtil.getDateTime(value);
        for (int i = 0; i < intervals.size(); ++i) {
            Pair<DateTime, DateTime> interval = intervals.get(i);
            if (i == intervals.size() - 1 && dateTime.isAfter((ReadableInstant)interval.getSecond())) {
                return i;
            }
            if (!dateTime.isAfter((ReadableInstant)interval.getFirst()) || !dateTime.isBefore((ReadableInstant)interval.getSecond())) continue;
            return i;
        }
        return -1;
    }

    public static String getTimeFilter(Pair<DateTime, DateTime> timespan) {
        String result;
        DateTime now = TimeUtil.now();
        long toDelta = now.getMillis() - ((DateTime)timespan.getSecond()).getMillis();
        long toMinDelta = TimeUnit.MILLISECONDS.toMinutes(toDelta);
        if (toMinDelta <= 2L) {
            long fromDelta = ((DateTime)timespan.getSecond()).getMillis() - ((DateTime)timespan.getFirst()).getMillis();
            long minDelta = TimeUnit.MILLISECONDS.toMinutes(fromDelta);
            String timeRange = TimeUtil.getTimeRange((int)minDelta);
            result = LAST_TIME_WINDOW + timeRange;
        } else {
            result = TimeUtil.toTimeFilter((DateTime)timespan.getFirst(), (DateTime)timespan.getSecond());
        }
        return result;
    }

    public static DateTime now() {
        return DateTime.now((DateTimeZone)DateTimeZone.UTC);
    }

    public static Pair<DateTime, DateTime> getTimeFilter(String timeFilter) {
        if (timeFilter == null || timeFilter.isEmpty()) {
            throw new IllegalArgumentException("timeFilter cannot be empty");
        }
        if (timeFilter.startsWith(LAST_TIME_WINDOW)) {
            DateTime to = TimeUtil.now();
            DateTime from = to.minusMinutes(TimeUtil.getTimeDelta(timeFilter));
            return Pair.of((Object)from, (Object)to);
        }
        if (timeFilter.contains(RANGE_WINDOW)) {
            DateTime from = TimeUtil.getTimeGreaterThan(timeFilter);
            DateTime to = TimeUtil.getTimeLessThan(timeFilter);
            return Pair.of((Object)from, (Object)to);
        }
        if (timeFilter.startsWith(SO_FAR_WINDOW)) {
            DateTime to = TimeUtil.now();
            DateTime from = TimeUtil.getTimeGreaterThan(timeFilter);
            return Pair.of((Object)from, (Object)to);
        }
        throw new IllegalArgumentException("Could not parse time filter " + timeFilter);
    }

    public static String toString(DateTime value) {
        return value.toString(fmt);
    }

    public static Pair<String, String> toTimespan(Pair<DateTime, DateTime> pair) {
        return Pair.of((Object)((DateTime)pair.getFirst()).toString(fmt), (Object)((DateTime)pair.getSecond()).toString(fmt));
    }

    public static Pair<String, String> toTimespan(DateTime from, DateTime to) {
        return Pair.of((Object)from.toString(fmt), (Object)to.toString(fmt));
    }

    public static Pair<String, String> parseTimeFilter(String timeFilter) {
        Pair<DateTime, DateTime> pair = TimeUtil.getTimeFilter(timeFilter);
        return TimeUtil.toTimespan(pair);
    }

    public static String prettifyTime(String value) {
        DateTime dateTime = fmt.parseDateTime(value);
        String result = prettyTime.formatDuration(new Date(dateTime.getMillis()));
        return result;
    }

    public static int toMinutes(long milli) {
        return (int)(milli / 1000L / 60L);
    }

    private static DateTime getTimeGreaterThan(String timeFilter) {
        int unitIndex = timeFilter.indexOf(MILLI_UNIT);
        String value = timeFilter.substring(SO_FAR_WINDOW.length(), unitIndex);
        DateTime result = new DateTime((Object)Long.valueOf(value), DateTimeZone.UTC);
        return result;
    }

    private static DateTime getTimeLessThan(String timeFilter) {
        int rangeIndex = timeFilter.indexOf(RANGE_WINDOW);
        String timeWindow = timeFilter.substring(rangeIndex + RANGE_WINDOW.length(), timeFilter.length() - MILLI_UNIT.length());
        DateTime result = new DateTime((Object)Long.valueOf(timeWindow), DateTimeZone.UTC);
        return result;
    }

    public static String getTimeRange(String timeFilter) {
        String result = TimeUtil.getTimeUnit(timeFilter);
        if (result == null) {
            return DEFAULT_TIME_RANGE_STR;
        }
        return result;
    }

    public static String getTimeUnit(String timeFilter) {
        if (timeFilter == null || !timeFilter.contains(LAST_TIME_WINDOW)) {
            return null;
        }
        String result = timeFilter.substring(LAST_TIME_WINDOW.length(), timeFilter.length());
        return result;
    }

    private static int getTimeDelta(String timeFilter) {
        return TimeUtil.parseInterval(TimeUtil.getTimeUnit(timeFilter));
    }

    public static String toTimeFilter(Pair<DateTime, DateTime> timespan) {
        return TimeUtil.toTimeFilter((DateTime)timespan.getFirst(), (DateTime)timespan.getSecond());
    }

    public static String toTimeFilter(DateTime from, DateTime to) {
        return SO_FAR_WINDOW + from.getMillis() + MILLI_UNIT + " " + RANGE_WINDOW + to.getMillis() + MILLI_UNIT;
    }

    public static String getTimeRange(Pair<DateTime, DateTime> timespan) {
        String result;
        long toDelta = TimeUtil.now().getMillis() - ((DateTime)timespan.getSecond()).getMillis();
        if (TimeUnit.MILLISECONDS.toMinutes(toDelta) < 1L) {
            long fromDelta = ((DateTime)timespan.getSecond()).getMillis() - ((DateTime)timespan.getFirst()).getMillis();
            long minDelta = TimeUnit.MILLISECONDS.toMinutes(fromDelta);
            result = TimeUtil.getTimeRange((int)minDelta);
        } else {
            result = null;
        }
        return result;
    }

    public static int getIntervalMin(String interval) {
        switch (interval) {
            case "Hour": {
                return (int)TimeUnit.HOURS.toMinutes(1L);
            }
            case "Day": {
                return (int)TimeUnit.DAYS.toMinutes(1L);
            }
            case "Week": {
                return (int)TimeUnit.DAYS.toMinutes(7L);
            }
        }
        String range = TimeUtil.getTimeRange(interval);
        if (range == null) {
            throw new IllegalStateException(String.valueOf(interval));
        }
        return TimeUtil.parseInterval(range);
    }

    public static Pair<DateTime, Integer> getPeriodStart(Pair<DateTime, DateTime> timespan, String interval) {
        DateTime periodFrom;
        int delta = TimeUtil.getIntervalMin(interval);
        switch (interval) {
            case "Hour": {
                periodFrom = ((DateTime)timespan.getSecond()).withMinuteOfHour(0);
                break;
            }
            case "Day": {
                periodFrom = ((DateTime)timespan.getSecond()).withMillisOfDay(0);
                break;
            }
            case "Week": {
                periodFrom = ((DateTime)timespan.getSecond()).withMillisOfDay(0);
                break;
            }
            default: {
                periodFrom = ((DateTime)timespan.getSecond()).withMillisOfDay(0);
            }
        }
        return Pair.of((Object)periodFrom, (Object)delta);
    }

    public static Collection<Pair<DateTime, DateTime>> getTimespanPeriods(Pair<DateTime, DateTime> timespan, DateTime start, int delta, boolean addLastInterval) {
        DateTime periodFrom;
        if (((DateTime)timespan.getSecond()).minus(((DateTime)timespan.getFirst()).getMillis()).getMillis() <= TimeUnit.MINUTES.toMillis(delta)) {
            return Collections.singleton(timespan);
        }
        ArrayList<Pair<DateTime, DateTime>> result = new ArrayList<Pair<DateTime, DateTime>>();
        DateTime periodTo = periodFrom = start;
        result.add(Pair.of((Object)periodFrom, (Object)timespan.getSecond()));
        while (periodFrom.isAfter((ReadableInstant)timespan.getFirst())) {
            if ((periodFrom = periodFrom.minusMinutes(delta)).isAfter((ReadableInstant)timespan.getFirst())) {
                result.add((Pair<DateTime, DateTime>)Pair.of((Object)periodFrom, (Object)periodTo));
            } else {
                long priodDelta = TimeUnit.MILLISECONDS.toMinutes(periodTo.getMillis() - ((DateTime)timespan.getFirst()).getMillis());
                if (addLastInterval || priodDelta >= (long)delta) {
                    result.add((Pair<DateTime, DateTime>)Pair.of((Object)timespan.getFirst(), (Object)periodTo));
                }
            }
            periodTo = periodFrom;
        }
        return result;
    }

    public static long getTimespanMill(Pair<DateTime, DateTime> timespan) {
        return ((DateTime)timespan.getSecond()).getMillis() - ((DateTime)timespan.getFirst()).getMillis();
    }
}

