/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client;

import com.takipi.api.client.ApiClient;
import com.takipi.api.client.BaseApiClient;
import com.takipi.api.client.observe.Observer;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.Pair;
import com.takipi.common.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RemoteApiClient
extends BaseApiClient
implements ApiClient {
    private final int apiVersion;

    RemoteApiClient(String hostname, Pair<String, String> auth, int apiVersion, int connectTimeout, int readTimeout, UrlClient.LogLevel defaultLogLevel, Map<Integer, UrlClient.LogLevel> responseLogLevels, Collection<Observer> observers) {
        super(hostname, auth, connectTimeout, readTimeout, defaultLogLevel, responseLogLevels, observers);
        this.apiVersion = apiVersion;
    }

    @Override
    public int getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteApiClient)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RemoteApiClient other = (RemoteApiClient)obj;
        return this.apiVersion == other.apiVersion;
    }

    public UrlClient.Response<String> testConnection() {
        return this.get(this.baseApiPath() + "/test", "application/json", new String[0]);
    }

    public boolean validateConnection() {
        try {
            UrlClient.Response<String> response = this.testConnection();
            return response != null && !response.isBadResponse();
        }
        catch (Exception e) {
            logger.error("Api url client validate connection to {} failed.", (Object)this.getHostname(), (Object)e);
            return false;
        }
    }

    @Override
    protected String baseApiPath() {
        return this.getHostname() + "/api/v" + this.apiVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends BaseApiClient.Builder {
        private static final int API_VERSION = 1;
        private int apiVersion = 1;

        Builder() {
        }

        @Override
        public Builder setHostname(String hostname) {
            super.setHostname(hostname);
            return this;
        }

        @Override
        public Builder setUsername(String username) {
            super.setUsername(username);
            return this;
        }

        @Override
        public Builder setPassword(String password) {
            super.setPassword(password);
            return this;
        }

        @Override
        public Builder setApiKey(String apiKey) {
            super.setApiKey(apiKey);
            return this;
        }

        public Builder setApiVersion(int apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @Override
        public Builder setConnectTimeout(int connectTimeout) {
            super.setConnectTimeout(connectTimeout);
            return this;
        }

        @Override
        public Builder setReadTimeout(int readTimeout) {
            super.setReadTimeout(readTimeout);
            return this;
        }

        @Override
        public Builder setDefaultLogLevel(UrlClient.LogLevel defaultLogLevel) {
            super.setDefaultLogLevel(defaultLogLevel);
            return this;
        }

        @Override
        public Builder setResponseLogLevel(int responseCode, UrlClient.LogLevel logLevel) {
            super.setResponseLogLevel(responseCode, logLevel);
            return this;
        }

        @Override
        public Builder addObserver(Observer observer) {
            super.addObserver(observer);
            return this;
        }

        public ApiClient build() {
            if (StringUtil.isNullOrEmpty(this.hostname)) {
                throw new IllegalArgumentException("Missing hostname");
            }
            return new RemoteApiClient(this.hostname, this.getAuth(), this.apiVersion, this.connectTimeout, this.readTimeout, this.defaultLogLevel, new HashMap<Integer, UrlClient.LogLevel>(this.responseLogLevels), this.observers);
        }
    }
}

