/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request;

import com.takipi.api.client.request.TimeframeRequest;
import com.takipi.api.client.util.validation.ValidationUtil;
import java.util.Collection;

public abstract class EventTimeframeRequest
extends TimeframeRequest {
    public final String eventId;

    protected EventTimeframeRequest(String serviceId, String eventId, String from, String to, Collection<String> servers, Collection<String> apps, Collection<String> deployments) {
        super(serviceId, from, to, servers, apps, deployments);
        this.eventId = eventId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends TimeframeRequest.Builder {
        protected String eventId;

        public Builder setEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (!ValidationUtil.isLegalEventId(this.eventId)) {
                throw new IllegalArgumentException("Illegal event id - " + this.eventId);
            }
        }
    }
}

