/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import org.joda.time.DateTime;

public abstract class TimeframeRequest
extends ServiceRequest {
    public final String from;
    public final String to;
    public final Collection<String> servers;
    public final Collection<String> apps;
    public final Collection<String> deployments;

    protected TimeframeRequest(String serviceId, String from, String to, Collection<String> servers, Collection<String> apps, Collection<String> deployments) {
        super(serviceId);
        this.from = from;
        this.to = to;
        this.servers = servers;
        this.apps = apps;
        this.deployments = deployments;
    }

    protected String[] buildParams() throws UnsupportedEncodingException {
        String[] params = new String[this.paramsCount()];
        this.fillParams(params, 0);
        return params;
    }

    protected int paramsCount() {
        return 2 + this.servers.size() + this.apps.size() + this.deployments.size();
    }

    protected int fillParams(String[] params, int startIndex) throws UnsupportedEncodingException {
        int index = startIndex;
        params[index++] = "from=" + TimeframeRequest.encode(this.from);
        params[index++] = "to=" + TimeframeRequest.encode(this.to);
        for (String server : this.servers) {
            params[index++] = "server=" + TimeframeRequest.encode(server);
        }
        for (String app : this.apps) {
            params[index++] = "app=" + TimeframeRequest.encode(app);
        }
        for (String deployment : this.deployments) {
            params[index++] = "deployment=" + TimeframeRequest.encode(deployment);
        }
        return index;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        protected String from;
        protected String to;
        protected Collection<String> servers = new HashSet<String>();
        protected Collection<String> apps = new HashSet<String>();
        protected Collection<String> deployments = new HashSet<String>();

        protected Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder addServer(String server) {
            if (StringUtil.isNullOrEmpty(server)) {
                throw new IllegalArgumentException();
            }
            this.servers.add(server);
            return this;
        }

        public Builder addApp(String app) {
            if (StringUtil.isNullOrEmpty(app)) {
                throw new IllegalArgumentException();
            }
            this.apps.add(app);
            return this;
        }

        public Builder addDeployment(String deployment) {
            if (StringUtil.isNullOrEmpty(deployment)) {
                throw new IllegalArgumentException();
            }
            this.deployments.add(deployment);
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            try {
                DateTime.parse((String)this.from);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal from time - " + this.from, e);
            }
            try {
                DateTime.parse((String)this.to);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal to time - " + this.to, e);
            }
        }
    }
}

