/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.category;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.category.CreateCategoryResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.common.util.JsonUtil;
import com.takipi.common.util.StringUtil;
import java.util.HashMap;

public class CreateCategoryRequest
extends ServiceRequest
implements ApiPostRequest<CreateCategoryResult> {
    private final String name;
    private final boolean shared;

    CreateCategoryRequest(String serviceId, String name, boolean shared) {
        super(serviceId);
        this.name = name;
        this.shared = shared;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/categories";
    }

    @Override
    public String postData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", JsonUtil.stringify(this.name));
        map.put("shared", Boolean.toString(this.shared));
        return JsonUtil.createSimpleJson(map, false);
    }

    @Override
    public Class<CreateCategoryResult> resultClass() {
        return CreateCategoryResult.class;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String name;
        private boolean shared;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setShared(boolean shared) {
            this.shared = shared;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (StringUtil.isNullOrEmpty(this.name)) {
                throw new IllegalArgumentException("Missing name");
            }
        }

        public CreateCategoryRequest build() {
            this.validate();
            return new CreateCategoryRequest(this.serviceId, this.name, this.shared);
        }
    }
}

