/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.event;

import com.takipi.api.client.request.label.ModifyLabelsRequest;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.JsonUtil;
import java.util.Collection;
import java.util.HashSet;

public class EventModifyLabelsRequest
extends ModifyLabelsRequest {
    private final String eventId;
    private final Collection<String> addLabels;
    private final Collection<String> removeLabels;

    EventModifyLabelsRequest(String serviceId, String eventId, Collection<String> addLabels, Collection<String> removeLabels, boolean forceHistory, boolean handleSimilarEvents) {
        super(serviceId, forceHistory, handleSimilarEvents);
        this.eventId = eventId;
        this.addLabels = addLabels;
        this.removeLabels = removeLabels;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/events/" + this.eventId + "/labels";
    }

    @Override
    public String postData() {
        return JsonUtil.createSimpleJson(CollectionUtil.mapOf("add", JsonUtil.createSimpleJson(this.addLabels, true), "remove", JsonUtil.createSimpleJson(this.removeLabels, true)));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ModifyLabelsRequest.Builder {
        private String eventId;
        private final Collection<String> addLabels = new HashSet<String>();
        private final Collection<String> removeLabels = new HashSet<String>();

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        @Override
        public Builder setForceHistory(boolean forceHistory) {
            super.setForceHistory(forceHistory);
            return this;
        }

        @Override
        public Builder setHandleSimilarEvents(boolean handleSimilarEvents) {
            super.setHandleSimilarEvents(handleSimilarEvents);
            return this;
        }

        public Builder setEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder addLabel(String label) {
            this.addLabels.add(label);
            this.removeLabels.remove(label);
            return this;
        }

        public Builder addLabels(Collection<String> labels) {
            this.addLabels.addAll(labels);
            this.removeLabels.removeAll(labels);
            return this;
        }

        public Builder removeLabel(String label) {
            this.addLabels.remove(label);
            this.removeLabels.add(label);
            return this;
        }

        public Builder removeLabels(Collection<String> labels) {
            this.addLabels.removeAll(labels);
            this.removeLabels.addAll(labels);
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (!ValidationUtil.isLegalEventId(this.eventId)) {
                throw new IllegalArgumentException("Illegal event id - " + this.eventId);
            }
            if (this.addLabels.size() + this.removeLabels.size() == 0) {
                throw new IllegalArgumentException("Must modify labels");
            }
        }

        public EventModifyLabelsRequest build() {
            this.validate();
            return new EventModifyLabelsRequest(this.serviceId, this.eventId, this.addLabels, this.removeLabels, this.forceHistory, this.handleSimilarEvents);
        }
    }
}

