/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.event;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import java.io.UnsupportedEncodingException;

public class EventRequest
extends ServiceRequest
implements ApiGetRequest<EventResult> {
    public final String eventId;
    public final boolean includeStacktrace;

    EventRequest(String serviceId, String eventId, boolean includeStacktrace) {
        super(serviceId);
        this.eventId = eventId;
        this.includeStacktrace = includeStacktrace;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/events/" + this.eventId;
    }

    @Override
    public String[] queryParams() throws UnsupportedEncodingException {
        String[] params = new String[]{"stacktrace=" + Boolean.toString(this.includeStacktrace)};
        return params;
    }

    @Override
    public Class<EventResult> resultClass() {
        return EventResult.class;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String eventId;
        private boolean includeStacktrace;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder setIncludeStacktrace(boolean includeStacktrace) {
            this.includeStacktrace = includeStacktrace;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (!ValidationUtil.isLegalEventId(this.eventId)) {
                throw new IllegalArgumentException("Illegal event id - " + this.eventId);
            }
        }

        public EventRequest build() {
            this.validate();
            return new EventRequest(this.serviceId, this.eventId, this.includeStacktrace);
        }
    }
}

