/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.event;

import com.takipi.api.client.request.ViewTimeframeRequest;
import com.takipi.api.client.result.event.EventsSlimVolumeResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import java.io.UnsupportedEncodingException;
import java.util.Collection;

public class EventsSlimVolumeRequest
extends ViewTimeframeRequest
implements ApiGetRequest<EventsSlimVolumeResult> {
    public final ValidationUtil.VolumeType volumeType;
    public final boolean breakServers;
    public final boolean breakApps;
    public final boolean breakDeployments;

    EventsSlimVolumeRequest(String serviceId, String viewId, ValidationUtil.VolumeType volumeType, String from, String to, boolean raw, Collection<String> servers, Collection<String> apps, Collection<String> deployments, boolean breakServers, boolean breakApps, boolean breakDeployments) {
        super(serviceId, viewId, from, to, raw, servers, apps, deployments);
        this.volumeType = volumeType;
        this.breakServers = breakServers;
        this.breakApps = breakApps;
        this.breakDeployments = breakDeployments;
    }

    @Override
    public Class<EventsSlimVolumeResult> resultClass() {
        return EventsSlimVolumeResult.class;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/views/" + this.viewId + "/events/stats/";
    }

    @Override
    protected int paramsCount() {
        return super.paramsCount() + 4;
    }

    @Override
    protected int fillParams(String[] params, int startIndex) throws UnsupportedEncodingException {
        int index = super.fillParams(params, startIndex);
        params[index++] = "stats=" + this.volumeType.toString();
        params[index++] = "breakServers=" + Boolean.toString(this.breakServers);
        params[index++] = "breakApps=" + Boolean.toString(this.breakApps);
        params[index++] = "breakDeployments=" + Boolean.toString(this.breakDeployments);
        return index;
    }

    @Override
    public String[] queryParams() throws UnsupportedEncodingException {
        return this.buildParams();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ViewTimeframeRequest.Builder {
        private ValidationUtil.VolumeType volumeType;
        private boolean breakServers;
        private boolean breakApps;
        private boolean breakDeployments;

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        @Override
        public Builder setViewId(String viewId) {
            super.setViewId(viewId);
            return this;
        }

        @Override
        public Builder setRaw(boolean raw) {
            super.setRaw(raw);
            return this;
        }

        public Builder setVolumeType(ValidationUtil.VolumeType volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public Builder setFrom(String from) {
            super.setFrom(from);
            return this;
        }

        @Override
        public Builder setTo(String to) {
            super.setTo(to);
            return this;
        }

        @Override
        public Builder addServer(String server) {
            super.addServer(server);
            return this;
        }

        @Override
        public Builder addApp(String app) {
            super.addApp(app);
            return this;
        }

        @Override
        public Builder addDeployment(String deployment) {
            super.addDeployment(deployment);
            return this;
        }

        public Builder setBreakServers(boolean breakServers) {
            this.breakServers = breakServers;
            return this;
        }

        public Builder setBreakApps(boolean breakApps) {
            this.breakApps = breakApps;
            return this;
        }

        public Builder setBreakDeployments(boolean breakDeployments) {
            this.breakDeployments = breakDeployments;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.volumeType == null) {
                throw new IllegalArgumentException("Missing volume type");
            }
        }

        public EventsSlimVolumeRequest build() {
            this.validate();
            return new EventsSlimVolumeRequest(this.serviceId, this.viewId, this.volumeType, this.from, this.to, this.raw, this.servers, this.apps, this.deployments, this.breakServers, this.breakApps, this.breakDeployments);
        }
    }
}

