/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.functions.settings;

import com.takipi.api.client.request.functions.settings.FunctionSettingRequest;
import com.takipi.api.client.result.EmptyResult;
import com.takipi.api.core.request.intf.ApiPutRequest;
import com.takipi.common.util.JsonUtil;
import com.takipi.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Collections;

public class PutFunctionSettingRequest
extends FunctionSettingRequest
implements ApiPutRequest<EmptyResult> {
    public final String value;

    PutFunctionSettingRequest(String serviceId, String libraryId, String functionId, String key, String value) {
        super(serviceId, libraryId, functionId, key);
        this.value = value;
    }

    @Override
    public byte[] putData() throws UnsupportedEncodingException {
        String data = JsonUtil.createSimpleJson(Collections.singletonMap("value", JsonUtil.escapeText(this.value)), true);
        return data.getBytes("UTF-8");
    }

    @Override
    public Class<EmptyResult> resultClass() {
        return EmptyResult.class;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends FunctionSettingRequest.Builder {
        private String value;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        @Override
        public Builder setLibraryId(String libraryId) {
            super.setLibraryId(libraryId);
            return this;
        }

        @Override
        public Builder setFunctionId(String functionId) {
            super.setFunctionId(functionId);
            return this;
        }

        @Override
        public Builder setKey(String key) {
            super.setKey(key);
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (StringUtil.isNullOrEmpty(this.value)) {
                throw new IllegalArgumentException("Missing value");
            }
        }

        public PutFunctionSettingRequest build() {
            this.validate();
            return new PutFunctionSettingRequest(this.serviceId, this.libraryId, this.functionId, this.key, this.value);
        }
    }
}

